/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcRequest;

public class RequestBuilder {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final ObjectNode parameters = OBJECT_MAPPER.createObjectNode();
    private final String methodName;

    public RequestBuilder(String methodName) {
        this.methodName = methodName;
    }

    public RequestBuilder withParameter(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    public RequestBuilder withOptionalParameter(String name, String value) {
        if (value != null && !"".equals(value.trim())) {
            return this.withParameter(name, value);
        }
        return this;
    }

    public RequestBuilder withOptionalParameter(String name, Object value) {
        if (value instanceof String) {
            return this.withOptionalParameter(name, (String)value);
        }
        if (value != null) {
            return this.withParameter(name, value);
        }
        return this;
    }

    public RequestBuilder withOptionalParameterAsList(String name, List value) {
        if (value != null && !value.isEmpty()) {
            return this.withParameter(name, value);
        }
        return this;
    }

    public RequestBuilder withOptionalParameterAsMap(String name, Map value) {
        if (value != null && !value.isEmpty()) {
            return this.withParameter(name, value);
        }
        return this;
    }

    public RequestBuilder withParameter(String name, Object value) {
        this.parameters.putPOJO(name, value);
        return this;
    }

    public JsonRpcRequest build() {
        TextNode id = this.parameters.textNode(UUID.randomUUID().toString());
        return new JsonRpcRequest(this.methodName, (JsonNode)this.parameters, (JsonNode)id);
    }
}

