/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;

public final class JsonRpcResponse {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private JsonNode result;
    private JsonNode error;
    private JsonNode id;

    public JsonRpcResponse(JsonNode result, JsonNode error, JsonNode id) {
        this.result = result;
        this.error = error;
        this.id = id;
    }

    public JsonNode getResult() {
        return this.result;
    }

    public void setResult(JsonNode result) {
        this.result = result;
    }

    public JsonNode getError() {
        return this.error;
    }

    public void setError(JsonNode error) {
        this.error = error;
    }

    public JsonNode getId() {
        return this.id;
    }

    public void setId(JsonNode node) {
        this.id = node;
    }

    public static JsonRpcResponse fromByteArray(byte[] message) {
        try {
            return JsonRpcResponse.fromJsonNode(MAPPER.readTree(message));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static JsonRpcResponse fromJsonNode(JsonNode node) {
        JsonNode jsonrpcNode = node.get("jsonrpc");
        if (jsonrpcNode == null) {
            throw new IllegalArgumentException("'jsonrpc' field missing in node");
        }
        String version = jsonrpcNode.asText();
        if (version == null || !version.equals("2.0")) {
            throw new IllegalArgumentException("Only jsonrpc 2.0 is supported");
        }
        JsonNode id = node.get("id");
        if (id == null) {
            throw new IllegalArgumentException("Response missing id field");
        }
        return new JsonRpcResponse(node.get("result"), node.get("error"), id);
    }

    public byte[] toByteArray() {
        ObjectNode node = MAPPER.createObjectNode();
        node.put("jsonrpc", "2.0");
        if (this.getError() != null) {
            node.put("error", this.getError());
        }
        if (this.getResult() != null) {
            node.put("result", this.getResult());
        }
        if (this.getId() == null) {
            node.putNull("id");
        } else {
            node.put("id", this.getId());
        }
        return JsonUtils.jsonToByteArray((JsonNode)node);
    }

    public String toString() {
        String response = this.getResult() != null ? " result: " + this.toPrintableResult(this.getResult()) : " error: " + this.getError().toString();
        return "<JsonRpcResponse id: " + this.getId() + response + ">";
    }

    private Object toPrintableResult(JsonNode result) {
        if (result.isArray() || result.isBoolean() || result.isTextual()) {
            return result;
        }
        Class<Map> clazz = Map.class;
        Map resultMap = (Map)MAPPER.convertValue((Object)result, clazz);
        if (resultMap.containsKey("password")) {
            resultMap.put("password", "*****");
        }
        return resultMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRpcResponse that = (JsonRpcResponse)o;
        return Objects.equals(this.result, that.result) && Objects.equals(this.error, that.error) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.result, this.error, this.id);
    }
}

