/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ovirt.vdsm.jsonrpc.client.BrokerCommandCallback;
import org.ovirt.vdsm.jsonrpc.client.ClientConnectionException;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcRequest;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcResponse;
import org.ovirt.vdsm.jsonrpc.client.internal.Call;
import org.ovirt.vdsm.jsonrpc.client.internal.ClientPolicy;
import org.ovirt.vdsm.jsonrpc.client.internal.JsonRpcCall;
import org.ovirt.vdsm.jsonrpc.client.internal.ResponseTracker;
import org.ovirt.vdsm.jsonrpc.client.reactors.ReactorClient;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonResponseUtil;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.ovirt.vdsm.jsonrpc.client.utils.ResponseTracking;
import org.ovirt.vdsm.jsonrpc.client.utils.retry.RetryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcClient {
    private final Logger log = LoggerFactory.getLogger(JsonRpcClient.class);
    private final ReactorClient client;
    private ResponseTracker tracker;
    private ClientPolicy policy;
    private ScheduledExecutorService executorService;

    public JsonRpcClient(ReactorClient client, ResponseTracker tracker) {
        this.client = client;
        this.tracker = tracker;
    }

    public void setClientRetryPolicy(ClientPolicy policy) {
        this.client.setClientPolicy(policy);
    }

    public void setRetryPolicy(ClientPolicy policy) {
        this.policy = policy;
    }

    public ClientPolicy getClientRetryPolicy() {
        return this.client.getRetryPolicy();
    }

    public ClientPolicy getRetryPolicy() {
        return this.policy;
    }

    public String getHostname() {
        return this.client.getHostname();
    }

    public int getConnectionId() {
        return this.client.getConnectionId();
    }

    public void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
        this.tracker.setExecutorService(executorService);
    }

    public Future<JsonRpcResponse> call(JsonRpcRequest req) throws ClientConnectionException {
        Call call = new Call(req);
        this.tracker.registerCall(req, call);
        this.retryCall(req, call);
        try {
            this.getClient().sendMessage(JsonUtils.jsonToByteArray(req.toJson()));
        }
        finally {
            this.retryCall(req, call);
        }
        return call;
    }

    public Future<JsonRpcResponse> call(JsonRpcRequest req, BrokerCommandCallback callback) throws ClientConnectionException {
        Call call = new Call(req, callback);
        this.tracker.registerCall(req, call);
        this.retryCall(req, call);
        boolean exceptionOccurred = false;
        try {
            this.getClient().sendMessage(JsonUtils.jsonToByteArray(req.toJson()));
        }
        catch (ClientConnectionException ex) {
            exceptionOccurred = true;
            throw ex;
        }
        finally {
            if (exceptionOccurred) {
                this.removeCall(call);
            } else {
                this.retryCall(req, call);
            }
        }
        return call;
    }

    public void removeCall(Future<JsonRpcResponse> call) {
        if (!Call.class.isInstance(call)) {
            return;
        }
        this.tracker.removeCall(((Call)call).getId());
    }

    private void retryCall(JsonRpcRequest request, JsonRpcCall call) {
        ResponseTracking tracking = new ResponseTracking(request, call, new RetryContext(this.policy), JsonUtils.getTimeout(this.policy.getRetryTimeOut(), this.policy.getTimeUnit()), this.client, !Objects.equals(request.getMethod(), "Host.ping"));
        this.tracker.registerTrackingRequest(request, tracking);
    }

    public ReactorClient getClient() throws ClientConnectionException {
        if (this.client.isOpen()) {
            return this.client;
        }
        this.client.connect();
        return this.client;
    }

    public void processResponse(JsonRpcResponse response) {
        JsonNode id = response.getId();
        if (NullNode.class.isInstance(id) || id == null) {
            this.tracker.processIssue(response);
            return;
        }
        JsonRpcCall call = this.tracker.removeCall(response.getId());
        if (call == null) {
            this.log.warn("Not able to update response for {}", (Object)response);
            return;
        }
        call.addResponse(response);
        if (call.getCallback() != null && this.executorService != null) {
            if (response.getError() != null) {
                this.executorService.schedule(() -> call.getCallback().onFailure(JsonUtils.mapValues(response.getError())), 0L, TimeUnit.SECONDS);
            } else {
                this.executorService.schedule(() -> call.getCallback().onResponse(new JsonResponseUtil().populate(response)), 0L, TimeUnit.SECONDS);
            }
        }
    }

    public void close() {
        this.client.close();
    }

    public boolean isClosed() {
        return this.client.isOpen();
    }
}

