/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcEvent;
import org.ovirt.vdsm.jsonrpc.client.ResponseDecomposer;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDecomposer {
    private static Logger log = LoggerFactory.getLogger(ResponseDecomposer.class);
    private static ObjectMapper mapper = new ObjectMapper();

    public EventDecomposer() {
        mapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
    }

    public Map<String, Object> decompose(JsonRpcEvent event) {
        try {
            return (Map)mapper.readValue(mapper.writeValueAsBytes((Object)event.getParams()), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            JsonUtils.logException(log, "Event decomposition failed", e);
            return null;
        }
    }
}

