/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.StringUtilsKt;
import org.ossreviewtoolkit.utils.common.UriUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0001\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0001\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a(\u0010\u0011\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014\u001a(\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0010\b\u0002\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"collapseWhitespace", "", "CONSECUTIVE_WHITESPACE_REGEX", "Lkotlin/text/Regex;", "encodeOr", "emptyValue", "encodeOrUnknown", "fileSystemEncode", "normalizeLineBreaks", "NON_LINUX_LINE_BREAKS_REGEX", "splitOnWhitespace", "", "NON_SPACE_REGEX", "titlecase", "unquote", "trimWhitespace", "", "withoutPrefix", "prefix", "missingPrefixValue", "Lkotlin/Function0;", "withoutSuffix", "suffix", "missingSuffixValue", "common-utils"})
@SourceDebugExtension(value={"SMAP\nStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtils.kt\norg/ossreviewtoolkit/utils/common/StringUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,93:1\n1#2:94\n1163#3,3:95\n108#4:98\n80#4,22:99\n*S KotlinDebug\n*F\n+ 1 StringUtils.kt\norg/ossreviewtoolkit/utils/common/StringUtilsKt\n*L\n66#1:95,3\n80#1:98\n80#1:99,22\n*E\n"})
public final class StringUtilsKt {
    @NotNull
    private static final Regex CONSECUTIVE_WHITESPACE_REGEX = new Regex("\\s+");
    @NotNull
    private static final Regex NON_LINUX_LINE_BREAKS_REGEX = new Regex("\\r\\n?");
    @NotNull
    private static final Regex NON_SPACE_REGEX = new Regex("\\S+");

    @NotNull
    public static final String collapseWhitespace(@NotNull String $this$collapseWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$collapseWhitespace, (String)"<this>");
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)$this$collapseWhitespace)).toString();
        Regex regex = CONSECUTIVE_WHITESPACE_REGEX;
        String string = " ";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final String encodeOr(@NotNull String $this$encodeOr, @NotNull String emptyValue) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$encodeOr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)emptyValue, (String)"emptyValue");
        if (!(((CharSequence)emptyValue).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CharSequence charSequence2 = $this$encodeOr;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = emptyValue;
        } else {
            charSequence = charSequence2;
        }
        return StringUtilsKt.fileSystemEncode((String)charSequence);
    }

    @NotNull
    public static final String encodeOrUnknown(@NotNull String $this$encodeOrUnknown) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeOrUnknown, (String)"<this>");
        return StringUtilsKt.encodeOr($this$encodeOrUnknown, "unknown");
    }

    @NotNull
    public static final String fileSystemEncode(@NotNull String $this$fileSystemEncode) {
        Intrinsics.checkNotNullParameter((Object)$this$fileSystemEncode, (String)"<this>");
        CharSequence charSequence = UriUtilsKt.percentEncode($this$fileSystemEncode);
        Regex regex = new Regex("(^\\.|\\.$)");
        String string = "%2E";
        return StringsKt.take((String)regex.replace(charSequence, string), (int)255);
    }

    @NotNull
    public static final String normalizeLineBreaks(@NotNull String $this$normalizeLineBreaks) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeLineBreaks, (String)"<this>");
        CharSequence charSequence = $this$normalizeLineBreaks;
        Regex regex = NON_LINUX_LINE_BREAKS_REGEX;
        String string = "\n";
        return regex.replace(charSequence, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> splitOnWhitespace(@NotNull String $this$splitOnWhitespace) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$splitOnWhitespace, (String)"<this>");
        Sequence sequence = Regex.findAll$default((Regex)NON_SPACE_REGEX, (CharSequence)$this$splitOnWhitespace, (int)0, (int)2, null);
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            MatchResult matchResult = (MatchResult)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        return (List)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String titlecase(@NotNull String $this$titlecase) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$titlecase, (String)"<this>");
        String string2 = $this$titlecase.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = string2;
        if (((CharSequence)string3).length() > 0) {
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)it));
            String string4 = string3;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string3;
        }
        return string;
    }

    @NotNull
    public static final String unquote(@NotNull String $this$unquote, boolean trimWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$unquote, (String)"<this>");
        String $this$trim$iv = $this$unquote;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = trimWhitespace && CharsKt.isWhitespace((char)it) || it == '\'' || it == '\"';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    public static /* synthetic */ String unquote$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return StringUtilsKt.unquote(string, bl);
    }

    @Nullable
    public static final String withoutPrefix(@Nullable String $this$withoutPrefix, @NotNull String prefix, @NotNull Function0<String> missingPrefixValue) {
        String string;
        block3: {
            block2: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                Intrinsics.checkNotNullParameter(missingPrefixValue, (String)"missingPrefixValue");
                string = $this$withoutPrefix;
                if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)prefix)) == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it, (Object)$this$withoutPrefix) ? string2 : null;
                if (string != null) break block3;
            }
            string = (String)missingPrefixValue.invoke();
        }
        return string;
    }

    public static /* synthetic */ String withoutPrefix$default(String string, String string2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = withoutPrefix.1.INSTANCE;
        }
        return StringUtilsKt.withoutPrefix(string, string2, (Function0<String>)function0);
    }

    @Nullable
    public static final String withoutSuffix(@Nullable String $this$withoutSuffix, @NotNull String suffix, @NotNull Function0<String> missingSuffixValue) {
        String string;
        block3: {
            block2: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
                Intrinsics.checkNotNullParameter(missingSuffixValue, (String)"missingSuffixValue");
                string = $this$withoutSuffix;
                if (string == null || (string = StringsKt.removeSuffix((String)string, (CharSequence)suffix)) == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it, (Object)$this$withoutSuffix) ? string2 : null;
                if (string != null) break block3;
            }
            string = (String)missingSuffixValue.invoke();
        }
        return string;
    }

    public static /* synthetic */ String withoutSuffix$default(String string, String string2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = withoutSuffix.1.INSTANCE;
        }
        return StringUtilsKt.withoutSuffix(string, string2, (Function0<String>)function0);
    }
}

