/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.Os;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.ossreviewtoolkit.utils.common.StringUtilsKt;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;
import org.semver4j.Semver;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\r\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aJ\u0014\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016JC\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u00112\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J+\u0010\r\u001a\u00020\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0014\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/ossreviewtoolkit/utils/common/CommandLineTool;", "", "command", "", "workingDir", "Ljava/io/File;", "getVersionArguments", "transformVersion", "output", "getVersionRequirement", "Lorg/semver4j/RangesList;", "isInPath", "", "run", "Lorg/ossreviewtoolkit/utils/common/ProcessCapture;", "args", "", "", "environment", "", "([Ljava/lang/CharSequence;Ljava/io/File;Ljava/util/Map;)Lorg/ossreviewtoolkit/utils/common/ProcessCapture;", "(Ljava/io/File;[Ljava/lang/CharSequence;)Lorg/ossreviewtoolkit/utils/common/ProcessCapture;", "getVersion", "checkVersion", "", "displayName", "Companion", "common-utils"})
public interface CommandLineTool {
    @NotNull
    public static final Companion Companion = org.ossreviewtoolkit.utils.common.CommandLineTool$Companion.$$INSTANCE;

    @NotNull
    public String command(@Nullable File var1);

    @NotNull
    public String getVersionArguments();

    @NotNull
    public String transformVersion(@NotNull String var1);

    @NotNull
    public RangesList getVersionRequirement();

    public boolean isInPath();

    @NotNull
    public ProcessCapture run(@NotNull CharSequence[] var1, @Nullable File var2, @NotNull Map<String, String> var3);

    @NotNull
    public ProcessCapture run(@Nullable File var1, CharSequence ... var2);

    @NotNull
    public String getVersion(@Nullable File var1);

    public void checkVersion(@Nullable File var1);

    @NotNull
    public String displayName();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/ossreviewtoolkit/utils/common/CommandLineTool$Companion;", "", "<init>", "()V", "ANY_VERSION", "Lorg/semver4j/RangesList;", "getANY_VERSION", "()Lorg/semver4j/RangesList;", "common-utils"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final RangesList ANY_VERSION;

        private Companion() {
        }

        @NotNull
        public final RangesList getANY_VERSION() {
            return ANY_VERSION;
        }

        static {
            $$INSTANCE = new Companion();
            RangesList rangesList = RangesListFactory.create((String)"*");
            Intrinsics.checkNotNullExpressionValue((Object)rangesList, (String)"create(...)");
            ANY_VERSION = rangesList;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nCommandLineTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandLineTool.kt\norg/ossreviewtoolkit/utils/common/CommandLineTool$DefaultImpls\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,120:1\n37#2:121\n36#2,3:122\n37#2:125\n36#2,3:126\n38#3:129\n*S KotlinDebug\n*F\n+ 1 CommandLineTool.kt\norg/ossreviewtoolkit/utils/common/CommandLineTool$DefaultImpls\n*L\n72#1:121\n72#1:122,3\n88#1:125\n88#1:126,3\n108#1:129\n*E\n"})
    public static final class DefaultImpls {
        public static /* synthetic */ String command$default(CommandLineTool commandLineTool, File file, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: command");
            }
            if ((n & 1) != 0) {
                file = null;
            }
            return commandLineTool.command(file);
        }

        @NotNull
        public static String getVersionArguments(@NotNull CommandLineTool $this) {
            return "--version";
        }

        @NotNull
        public static String transformVersion(@NotNull CommandLineTool $this, @NotNull String output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return output;
        }

        @NotNull
        public static RangesList getVersionRequirement(@NotNull CommandLineTool $this) {
            return Companion.getANY_VERSION();
        }

        public static boolean isInPath(@NotNull CommandLineTool $this) {
            return Os.INSTANCE.getPathFromEnvironment(DefaultImpls.command$default($this, null, 1, null)) != null;
        }

        @NotNull
        public static ProcessCapture run(@NotNull CommandLineTool $this, @NotNull CharSequence[] args, @Nullable File workingDir, @NotNull Map<String, String> environment) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter(environment, (String)"environment");
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            Collection $this$toTypedArray$iv = StringUtilsKt.splitOnWhitespace($this.command(workingDir));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
            spreadBuilder.addSpread((Object)args);
            return new ProcessCapture((CharSequence[])spreadBuilder.toArray((Object[])new CharSequence[spreadBuilder.size()]), workingDir, environment);
        }

        public static /* synthetic */ ProcessCapture run$default(CommandLineTool commandLineTool, CharSequence[] charSequenceArray, File file, Map map, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: run");
            }
            if ((n & 2) != 0) {
                file = null;
            }
            if ((n & 4) != 0) {
                map = MapsKt.emptyMap();
            }
            return commandLineTool.run(charSequenceArray, file, map);
        }

        @NotNull
        public static ProcessCapture run(@NotNull CommandLineTool $this, @Nullable File workingDir, CharSequence ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return $this.run(Arrays.copyOf(args, args.length), workingDir, MapsKt.emptyMap());
        }

        @NotNull
        public static String getVersion(@NotNull CommandLineTool $this, @Nullable File workingDir) {
            String versionString;
            String string;
            Object v1;
            block2: {
                Collection $this$toTypedArray$iv = StringUtilsKt.splitOnWhitespace($this.getVersionArguments());
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                ProcessCapture version = $this.run(workingDir, Arrays.copyOf(stringArray, stringArray.length)).requireSuccess();
                Object[] objectArray = new String[]{version.getStdout(), version.getStderr()};
                Sequence sequence = SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), arg_0 -> DefaultImpls.getVersion$lambda$0($this, arg_0));
                for (Object e : sequence) {
                    String it = (String)e;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    v1 = e;
                    break block2;
                }
                v1 = null;
            }
            if ((string = (versionString = (String)v1)) == null) {
                string = "";
            }
            return string;
        }

        public static /* synthetic */ String getVersion$default(CommandLineTool commandLineTool, File file, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getVersion");
            }
            if ((n & 1) != 0) {
                file = null;
            }
            return commandLineTool.getVersion(file);
        }

        public static void checkVersion(@NotNull CommandLineTool $this, @Nullable File workingDir) {
            Semver actualVersion = Semver.coerce((String)$this.getVersion(workingDir));
            RangesList requiredVersion = $this.getVersionRequirement();
            Semver semver = actualVersion;
            if (!(semver != null ? semver.satisfies(requiredVersion) : false)) {
                CommandLineTool $this$logger$iv = $this;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(CommandLineTool.class).warn(() -> DefaultImpls.checkVersion$lambda$2(requiredVersion, actualVersion));
            }
        }

        public static /* synthetic */ void checkVersion$default(CommandLineTool commandLineTool, File file, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkVersion");
            }
            if ((n & 1) != 0) {
                file = null;
            }
            commandLineTool.checkVersion(file);
        }

        @NotNull
        public static String displayName(@NotNull CommandLineTool $this) {
            String string = $this.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            return StringsKt.removeSuffix((String)string, (CharSequence)"Command");
        }

        private static String getVersion$lambda$0(CommandLineTool this$0, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.transformVersion(((Object)StringsKt.trim((CharSequence)it)).toString());
        }

        private static Object checkVersion$lambda$2(RangesList $requiredVersion, Semver $actualVersion) {
            return "The command is required in version " + $requiredVersion + ", but you are using version " + $actualVersion + ". This could lead to problems.";
        }
    }
}

