/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.Distance;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.PointL;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.LineDrawer;
import org.osmdroid.views.overlay.LinearRing;
import org.osmdroid.views.overlay.OverlayWithIW;
import org.osmdroid.views.overlay.PaintList;
import org.osmdroid.views.overlay.infowindow.InfoWindow;
import org.osmdroid.views.overlay.milestones.MilestoneManager;

public abstract class PolyOverlayWithIW
extends OverlayWithIW {
    protected LinearRing mOutline;
    protected List<LinearRing> mHoles = new ArrayList<LinearRing>();
    protected Paint mOutlinePaint = new Paint();
    protected Paint mFillPaint;
    private final List<PaintList> mOutlinePaintLists = new ArrayList<PaintList>();
    private List<MilestoneManager> mMilestoneManagers = new ArrayList<MilestoneManager>();
    private GeoPoint mInfoWindowLocation;
    private LineDrawer mLineDrawer;
    protected Path mPath;
    protected float mDensity = 1.0f;
    private boolean mIsPaintOrPaintList = true;
    private final PointL mVisibilityProjectedCenter = new PointL();
    private final PointL mVisibilityProjectedCorner = new PointL();
    private final PointL mVisibilityRectangleCenter = new PointL();
    private final PointL mVisibilityRectangleCorner = new PointL();
    private int mDowngradeMaximumPixelSize;
    private int mDowngradeMaximumRectanglePixelSize;
    private boolean mDowngradeDisplay;
    private final Point mDowngradeTopLeft = new Point();
    private final Point mDowngradeBottomRight = new Point();
    private final PointL mDowngradeCenter = new PointL();
    private final PointL mDowngradeOffset = new PointL();
    private float[] mDowngradeSegments;
    private float mDensityMultiplier = 1.0f;
    private final boolean mClosePath;

    protected PolyOverlayWithIW(MapView pMapView, boolean pUsePath, boolean pClosePath) {
        this.mClosePath = pClosePath;
        if (pMapView != null) {
            this.setInfoWindow(pMapView.getRepository().getDefaultPolylineInfoWindow());
            this.mDensity = pMapView.getContext().getResources().getDisplayMetrics().density;
        }
        this.usePath(pUsePath);
    }

    public void usePath(boolean pUsePath) {
        ArrayList<GeoPoint> previousPoints;
        ArrayList<GeoPoint> arrayList = previousPoints = this.mOutline == null ? null : this.mOutline.getPoints();
        if (pUsePath) {
            this.mPath = new Path();
            this.mLineDrawer = null;
            this.mOutline = new LinearRing(this.mPath, this.mClosePath);
        } else {
            this.mPath = null;
            this.mLineDrawer = new LineDrawer(256);
            this.mOutline = new LinearRing(this.mLineDrawer, this.mClosePath);
            this.mLineDrawer.setPaint(this.mOutlinePaint);
        }
        if (previousPoints != null) {
            this.setPoints(previousPoints);
        }
    }

    public void setVisible(boolean visible) {
        this.setEnabled(visible);
    }

    public boolean isVisible() {
        return this.isEnabled();
    }

    public Paint getOutlinePaint() {
        this.mIsPaintOrPaintList = true;
        return this.mOutlinePaint;
    }

    public List<PaintList> getOutlinePaintLists() {
        this.mIsPaintOrPaintList = false;
        return this.mOutlinePaintLists;
    }

    protected Paint getFillPaint() {
        return this.mFillPaint;
    }

    public void setGeodesic(boolean geodesic) {
        this.mOutline.setGeodesic(geodesic);
    }

    public boolean isGeodesic() {
        return this.mOutline.isGeodesic();
    }

    @Override
    public void setInfoWindow(InfoWindow infoWindow) {
        if (this.mInfoWindow != null && this.mInfoWindow.getRelatedObject() == this) {
            this.mInfoWindow.setRelatedObject(null);
        }
        this.mInfoWindow = infoWindow;
    }

    public void showInfoWindow() {
        if (this.mInfoWindow != null && this.mInfoWindowLocation != null) {
            this.mInfoWindow.open(this, this.mInfoWindowLocation, 0, 0);
        }
    }

    public void setInfoWindowLocation(GeoPoint location) {
        this.mInfoWindowLocation = location;
    }

    public GeoPoint getInfoWindowLocation() {
        return this.mInfoWindowLocation;
    }

    public void setMilestoneManagers(List<MilestoneManager> pMilestoneManagers) {
        if (pMilestoneManagers == null) {
            if (this.mMilestoneManagers.size() > 0) {
                this.mMilestoneManagers.clear();
            }
        } else {
            this.mMilestoneManagers = pMilestoneManagers;
        }
    }

    public double getDistance() {
        return this.mOutline.getDistance();
    }

    protected void setDefaultInfoWindowLocation() {
        int s = this.mOutline.getPoints().size();
        if (s == 0) {
            this.mInfoWindowLocation = new GeoPoint(0.0, 0.0);
            return;
        }
        if (this.mInfoWindowLocation == null) {
            this.mInfoWindowLocation = new GeoPoint(0.0, 0.0);
        }
        this.mOutline.getCenter(this.mInfoWindowLocation);
    }

    @Override
    public void draw(Canvas pCanvas, Projection pProjection) {
        if (!this.isVisible(pProjection)) {
            return;
        }
        if (this.mDowngradeMaximumPixelSize > 0 && !this.isWorthDisplaying(pProjection)) {
            if (this.mDowngradeDisplay) {
                this.displayDowngrade(pCanvas, pProjection);
            }
            return;
        }
        if (this.mPath != null) {
            this.drawWithPath(pCanvas, pProjection);
        } else {
            this.drawWithLines(pCanvas, pProjection);
        }
    }

    private boolean isVisible(Projection pProjection) {
        BoundingBox boundingBox = this.getBounds();
        pProjection.toProjectedPixels(boundingBox.getCenterLatitude(), boundingBox.getCenterLongitude(), this.mVisibilityProjectedCenter);
        pProjection.toProjectedPixels(boundingBox.getLatNorth(), boundingBox.getLonEast(), this.mVisibilityProjectedCorner);
        pProjection.getLongPixelsFromProjected(this.mVisibilityProjectedCenter, pProjection.getProjectedPowerDifference(), true, this.mVisibilityRectangleCenter);
        pProjection.getLongPixelsFromProjected(this.mVisibilityProjectedCorner, pProjection.getProjectedPowerDifference(), true, this.mVisibilityRectangleCorner);
        int screenCenterX = pProjection.getWidth() / 2;
        int screenCenterY = pProjection.getHeight() / 2;
        double radius = Math.sqrt(Distance.getSquaredDistanceToPoint(this.mVisibilityRectangleCenter.x, this.mVisibilityRectangleCenter.y, this.mVisibilityRectangleCorner.x, this.mVisibilityRectangleCorner.y));
        double distanceBetweenCenters = Math.sqrt(Distance.getSquaredDistanceToPoint(this.mVisibilityRectangleCenter.x, this.mVisibilityRectangleCenter.y, screenCenterX, screenCenterY));
        double screenRadius = Math.sqrt(Distance.getSquaredDistanceToPoint(0.0, 0.0, screenCenterX, screenCenterY));
        return distanceBetweenCenters <= radius + screenRadius;
    }

    private void drawWithPath(Canvas pCanvas, Projection pProjection) {
        this.mPath.rewind();
        this.mOutline.setClipArea(pProjection);
        PointL offset = this.mOutline.buildPathPortion(pProjection, null, this.mMilestoneManagers.size() > 0);
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.init();
            milestoneManager.setDistances(this.mOutline.getDistances());
            for (PointL point : this.mOutline.getPointsForMilestones()) {
                milestoneManager.add(point.x, point.y);
            }
            milestoneManager.end();
        }
        if (this.mHoles != null) {
            for (LinearRing hole : this.mHoles) {
                hole.setClipArea(pProjection);
                hole.buildPathPortion(pProjection, offset, this.mMilestoneManagers.size() > 0);
            }
            this.mPath.setFillType(Path.FillType.EVEN_ODD);
        }
        if (this.isVisible(this.mFillPaint)) {
            pCanvas.drawPath(this.mPath, this.mFillPaint);
        }
        if (this.isVisible(this.mOutlinePaint)) {
            pCanvas.drawPath(this.mPath, this.mOutlinePaint);
        }
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.draw(pCanvas);
        }
        if (this.isInfoWindowOpen() && this.mInfoWindow != null && this.mInfoWindow.getRelatedObject() == this) {
            this.mInfoWindow.draw();
        }
    }

    private void drawWithLines(Canvas pCanvas, Projection pProjection) {
        boolean storePoints;
        this.mLineDrawer.setCanvas(pCanvas);
        this.mOutline.setClipArea(pProjection);
        boolean bl = storePoints = this.mMilestoneManagers.size() > 0;
        if (this.mIsPaintOrPaintList) {
            Paint paint = this.getOutlinePaint();
            this.mLineDrawer.setPaint(paint);
            this.mOutline.buildLinePortion(pProjection, storePoints);
        } else {
            for (PaintList paintList : this.getOutlinePaintLists()) {
                this.mLineDrawer.setPaint(paintList);
                this.mOutline.buildLinePortion(pProjection, storePoints);
                storePoints = false;
            }
        }
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.init();
            milestoneManager.setDistances(this.mOutline.getDistances());
            for (PointL point : this.mOutline.getPointsForMilestones()) {
                milestoneManager.add(point.x, point.y);
            }
            milestoneManager.end();
        }
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.draw(pCanvas);
        }
        if (this.isInfoWindowOpen() && this.mInfoWindow != null && this.mInfoWindow.getRelatedObject() == this) {
            this.mInfoWindow.draw();
        }
    }

    @Override
    public void onDetach(MapView mapView) {
        if (this.mOutline != null) {
            this.mOutline.clear();
            this.mOutline = null;
        }
        this.mHoles.clear();
        this.mMilestoneManagers.clear();
        this.onDestroy();
    }

    @Override
    public BoundingBox getBounds() {
        return this.mOutline.getBoundingBox();
    }

    public void setPoints(List<GeoPoint> points) {
        this.mOutline.setPoints(points);
        this.setDefaultInfoWindowLocation();
    }

    public void addPoint(GeoPoint p) {
        this.mOutline.addPoint(p);
    }

    public List<GeoPoint> getActualPoints() {
        return this.mOutline.getPoints();
    }

    public void setDowngradeDisplay(boolean pDowngradeDisplay) {
        this.mDowngradeDisplay = pDowngradeDisplay;
    }

    public void setDowngradePixelSizes(int pPolySize, int pRectangleSize) {
        this.mDowngradeMaximumRectanglePixelSize = pRectangleSize;
        this.mDowngradeMaximumPixelSize = Math.max(pPolySize, pRectangleSize);
    }

    private boolean isWorthDisplaying(Projection pProjection) {
        BoundingBox boundingBox = this.getBounds();
        pProjection.toPixels(new GeoPoint(boundingBox.getLatNorth(), boundingBox.getLonEast()), this.mDowngradeTopLeft);
        pProjection.toPixels(new GeoPoint(boundingBox.getLatSouth(), boundingBox.getLonWest()), this.mDowngradeBottomRight);
        double worldSize = pProjection.getWorldMapSize();
        long right = Math.round(LinearRing.getCloserValue(this.mDowngradeTopLeft.x, this.mDowngradeBottomRight.x, worldSize));
        long bottom = Math.round(LinearRing.getCloserValue(this.mDowngradeTopLeft.y, this.mDowngradeBottomRight.y, worldSize));
        if (Math.abs(this.mDowngradeTopLeft.x - this.mDowngradeBottomRight.x) < this.mDowngradeMaximumPixelSize) {
            return false;
        }
        if (Math.abs((long)this.mDowngradeTopLeft.x - right) < (long)this.mDowngradeMaximumPixelSize) {
            return false;
        }
        if (Math.abs(this.mDowngradeTopLeft.y - this.mDowngradeBottomRight.y) < this.mDowngradeMaximumPixelSize) {
            return false;
        }
        return Math.abs((long)this.mDowngradeTopLeft.y - bottom) >= (long)this.mDowngradeMaximumPixelSize;
    }

    private boolean isVisible(Paint pPaint) {
        return pPaint != null && pPaint.getColor() != 0;
    }

    private void displayDowngrade(Canvas pCanvas, Projection pProjection) {
        long maxWidthHeight;
        PaintList paintList;
        long height;
        long width;
        BoundingBox boundingBox = this.mOutline.getBoundingBox();
        pProjection.toPixels(new GeoPoint(boundingBox.getLatNorth(), boundingBox.getLonEast()), this.mDowngradeTopLeft);
        pProjection.toPixels(new GeoPoint(boundingBox.getLatSouth(), boundingBox.getLonWest()), this.mDowngradeBottomRight);
        double worldSize = pProjection.getWorldMapSize();
        long left = this.mDowngradeTopLeft.x;
        long top = this.mDowngradeTopLeft.y;
        long right = Math.round(LinearRing.getCloserValue(left, this.mDowngradeBottomRight.x, worldSize));
        long bottom = Math.round(LinearRing.getCloserValue(top, this.mDowngradeBottomRight.y, worldSize));
        if (left == right) {
            width = 1L;
        } else if (left > right) {
            width = left - right;
            left = right;
        } else {
            width = right - left;
        }
        if (top == bottom) {
            height = 1L;
        } else if (top > bottom) {
            height = top - bottom;
            top = bottom;
        } else {
            height = bottom - top;
        }
        this.mDowngradeCenter.set(left + width / 2L, top + height / 2L);
        this.mOutline.getBestOffset(pProjection, this.mDowngradeOffset, this.mDowngradeCenter);
        left += this.mDowngradeOffset.x;
        top += this.mDowngradeOffset.y;
        Paint paint = null;
        if (this.mIsPaintOrPaintList) {
            paint = this.getOutlinePaint();
        } else if (this.getOutlinePaintLists().size() > 0 && (paint = (paintList = this.getOutlinePaintLists().get(0)).getPaint()) == null) {
            paint = paintList.getPaint(0, left, top, left + width, top + height);
        }
        if (!this.isVisible(paint)) {
            return;
        }
        long l = maxWidthHeight = width > height ? width : height;
        if (maxWidthHeight <= (long)this.mDowngradeMaximumRectanglePixelSize) {
            pCanvas.drawRect((float)left, (float)top, (float)(left + width), (float)(top + height), paint);
            return;
        }
        float[] downgradeList = this.mOutline.computeDowngradePointList(this.mDowngradeMaximumPixelSize);
        if (downgradeList == null || downgradeList.length == 0) {
            return;
        }
        int size = downgradeList.length * 2;
        if (this.mDowngradeSegments == null || this.mDowngradeSegments.length < size) {
            this.mDowngradeSegments = new float[size];
        }
        float factor = (float)maxWidthHeight * 1.0f / (float)this.mDowngradeMaximumPixelSize;
        int index = 0;
        float firstX = 0.0f;
        float firstY = 0.0f;
        int i = 0;
        while (i < downgradeList.length) {
            float currentX = (float)this.mDowngradeCenter.x + downgradeList[i++] * factor;
            float currentY = (float)this.mDowngradeCenter.y + downgradeList[i++] * factor;
            if (index == 0) {
                firstX = currentX;
                firstY = currentY;
            } else {
                this.mDowngradeSegments[index++] = currentX;
                this.mDowngradeSegments[index++] = currentY;
            }
            this.mDowngradeSegments[index++] = currentX;
            this.mDowngradeSegments[index++] = currentY;
        }
        this.mDowngradeSegments[index++] = firstX;
        this.mDowngradeSegments[index++] = firstY;
        if (index <= 4) {
            return;
        }
        pCanvas.drawLines(this.mDowngradeSegments, 0, index, paint);
    }

    protected abstract boolean click(MapView var1, GeoPoint var2);

    public void setDensityMultiplier(float pDensityMultiplier) {
        this.mDensityMultiplier = pDensityMultiplier;
    }

    public boolean contains(MotionEvent pEvent) {
        if (this.mPath.isEmpty()) {
            return false;
        }
        RectF bounds = new RectF();
        this.mPath.computeBounds(bounds, true);
        Region region = new Region();
        region.setPath(this.mPath, new Region((int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom));
        return region.contains((int)pEvent.getX(), (int)pEvent.getY());
    }

    public boolean isCloseTo(GeoPoint pPoint, double pTolerance, MapView pMapView) {
        return this.getCloseTo(pPoint, pTolerance, pMapView) != null;
    }

    public GeoPoint getCloseTo(GeoPoint pPoint, double pTolerance, MapView pMapView) {
        return this.mOutline.getCloseTo(pPoint, pTolerance, pMapView.getProjection(), this.mClosePath);
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent pEvent, MapView pMapView) {
        GeoPoint geoPoint;
        Projection projection = pMapView.getProjection();
        GeoPoint eventPos = (GeoPoint)projection.fromPixels((int)pEvent.getX(), (int)pEvent.getY());
        if (this.mPath != null) {
            boolean tapped = this.contains(pEvent);
            geoPoint = tapped ? eventPos : null;
        } else {
            double tolerance = this.mOutlinePaint.getStrokeWidth() * this.mDensity * this.mDensityMultiplier;
            geoPoint = this.getCloseTo(eventPos, tolerance, pMapView);
        }
        if (geoPoint != null) {
            return this.click(pMapView, geoPoint);
        }
        return false;
    }
}

