/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

public class Distance {
    public static double getSquaredDistanceToPoint(double pFromX, double pFromY, double pToX, double pToY) {
        double dX = pFromX - pToX;
        double dY = pFromY - pToY;
        return dX * dX + dY * dY;
    }

    public static double getSquaredDistanceToLine(double pFromX, double pFromY, double pAX, double pAY, double pBX, double pBY) {
        return Distance.getSquaredDistanceToProjection(pFromX, pFromY, pAX, pAY, pBX, pBY, Distance.getProjectionFactorToLine(pFromX, pFromY, pAX, pAY, pBX, pBY));
    }

    public static double getSquaredDistanceToSegment(double pFromX, double pFromY, double pAX, double pAY, double pBX, double pBY) {
        return Distance.getSquaredDistanceToProjection(pFromX, pFromY, pAX, pAY, pBX, pBY, Distance.getProjectionFactorToSegment(pFromX, pFromY, pAX, pAY, pBX, pBY));
    }

    public static double getSquaredDistanceToProjection(double pFromX, double pFromY, double pAX, double pAY, double pBX, double pBY, double pProjectionFactor) {
        double projectedX = pAX + (pBX - pAX) * pProjectionFactor;
        double projectedY = pAY + (pBY - pAY) * pProjectionFactor;
        return Distance.getSquaredDistanceToPoint(pFromX, pFromY, projectedX, projectedY);
    }

    public static double getProjectionFactorToLine(double pFromX, double pFromY, double pAX, double pAY, double pBX, double pBY) {
        if (pAX == pBX && pAY == pBY) {
            return 0.0;
        }
        return Distance.dotProduct(pAX, pAY, pBX, pBY, pFromX, pFromY) / Distance.getSquaredDistanceToPoint(pAX, pAY, pBX, pBY);
    }

    public static double getProjectionFactorToSegment(double pFromX, double pFromY, double pAX, double pAY, double pBX, double pBY) {
        double result = Distance.getProjectionFactorToLine(pFromX, pFromY, pAX, pAY, pBX, pBY);
        if (result < 0.0) {
            return 0.0;
        }
        if (result > 1.0) {
            return 1.0;
        }
        return result;
    }

    private static double dotProduct(double pAX, double pAY, double pBX, double pBY, double pCX, double pCY) {
        return (pBX - pAX) * (pCX - pAX) + (pBY - pAY) * (pCY - pAY);
    }
}

