/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonInclude;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonProperty;
import org.osiam.bundled.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.osiam.resources.helper.JsonDateSerializer;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Meta
implements Serializable {
    private static final long serialVersionUID = -4536271487921469946L;
    @JsonSerialize(using=JsonDateSerializer.class)
    private final Date created;
    @JsonSerialize(using=JsonDateSerializer.class)
    private final Date lastModified;
    private final String location;
    private final String version;
    private final Set<String> attributes;
    private final String resourceType;

    public Meta(@JsonProperty(value="created") @JsonSerialize(using=JsonDateSerializer.class) Date created, @JsonProperty(value="lastModified") @JsonSerialize(using=JsonDateSerializer.class) Date lastModified, @JsonProperty(value="location") String location, @JsonProperty(value="version") String version, @JsonProperty(value="attributes") Set<String> attributes, @JsonProperty(value="resourceType") String resourceType) {
        this.created = created;
        this.lastModified = lastModified;
        this.location = location;
        this.version = version;
        this.attributes = attributes;
        this.resourceType = resourceType;
    }

    private Meta(Builder builder) {
        this.created = builder.created;
        this.lastModified = builder.lastModified;
        this.attributes = builder.attributes;
        this.location = builder.location;
        this.version = builder.version;
        this.resourceType = builder.resourceType;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<String> getAttributes() {
        return this.attributes;
    }

    public Date getCreated() {
        if (this.created != null) {
            return new Date(this.created.getTime());
        }
        return null;
    }

    public Date getLastModified() {
        if (this.lastModified != null) {
            return new Date(this.lastModified.getTime());
        }
        return null;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.resourceType == null ? 0 : this.resourceType.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Meta other = (Meta)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.resourceType == null ? other.resourceType != null : !this.resourceType.equals(other.resourceType)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    /* synthetic */ Meta(Builder builder, Meta meta) {
        this(builder);
    }

    @Deprecated
    public static class Builder {
        private final Date created;
        private final Date lastModified;
        private String location;
        private String version;
        private Set<String> attributes = new HashSet<String>();
        private String resourceType;

        public Builder() {
            this.lastModified = this.created = new Date(System.currentTimeMillis());
        }

        public Builder(Date created, Date lastModified) {
            this.created = created != null ? new Date(created.getTime()) : null;
            this.lastModified = lastModified != null ? new Date(lastModified.getTime()) : null;
        }

        public Builder(Meta meta) {
            if (meta == null) {
                throw new IllegalArgumentException("The given Meta can't be null");
            }
            this.created = meta.created;
            this.lastModified = meta.lastModified;
            this.location = meta.location;
            this.version = meta.version;
            this.attributes = meta.attributes;
            this.resourceType = meta.resourceType;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setResourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder setAttributes(Set<String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Meta build() {
            return new Meta(this, null);
        }
    }
}

