/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonCreator;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonIgnore;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonProperty;
import org.osiam.bundled.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.osiam.resources.helper.ExtensionSerializer;
import org.osiam.resources.scim.ExtensionFieldType;

@JsonSerialize(using=ExtensionSerializer.class)
public final class Extension
implements Serializable {
    private static final long serialVersionUID = -121658804932369438L;
    @JsonIgnore
    private final String urn;
    private final Map<String, Field> fields;

    @JsonCreator
    private Extension(@JsonProperty(value="urn") String urn, @JsonProperty(value="fields") Map<String, Field> fields) {
        this.urn = urn;
        this.fields = fields != null ? ImmutableMap.copyOf(fields) : ImmutableMap.of();
    }

    private Extension(Builder builder) {
        this(builder.urn, builder.fields);
    }

    public String getUrn() {
        return this.urn;
    }

    public <T> T getField(String field, ExtensionFieldType<T> extensionFieldType) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("Invalid field name");
        }
        if (extensionFieldType == null) {
            throw new IllegalArgumentException("Invalid field type");
        }
        if (!this.isFieldPresent(field)) {
            throw new NoSuchElementException("Field " + field + " not valid in this extension");
        }
        return extensionFieldType.fromString(this.fields.get(field).value);
    }

    public String getFieldAsString(String field) {
        return this.getField(field, ExtensionFieldType.STRING);
    }

    public boolean getFieldAsBoolean(String field) {
        return this.getField(field, ExtensionFieldType.BOOLEAN);
    }

    public ByteBuffer getFieldAsByteBuffer(String field) {
        return this.getField(field, ExtensionFieldType.BINARY);
    }

    public Date getFieldAsDate(String field) {
        return this.getField(field, ExtensionFieldType.DATE_TIME);
    }

    public BigDecimal getFieldAsDecimal(String field) {
        return this.getField(field, ExtensionFieldType.DECIMAL);
    }

    public BigInteger getFieldAsInteger(String field) {
        return this.getField(field, ExtensionFieldType.INTEGER);
    }

    public URI getFieldAsReference(String field) {
        return this.getField(field, ExtensionFieldType.REFERENCE);
    }

    @JsonIgnore
    public Map<String, Field> getFields() {
        return this.fields;
    }

    public boolean isFieldPresent(String field) {
        return this.fields.containsKey(field);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        result = 31 * result + (this.urn == null ? 0 : this.urn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Extension other = (Extension)obj;
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        return !(this.urn == null ? other.urn != null : !this.urn.equals(other.urn));
    }

    public String toString() {
        StringBuilder stringPresentation = new StringBuilder();
        stringPresentation.append("Extension [urn=").append(this.urn).append("{");
        boolean firstEntry = true;
        for (String key : this.fields.keySet()) {
            Field field = this.fields.get(key);
            if (!firstEntry) {
                stringPresentation.append(", ");
            }
            firstEntry = false;
            stringPresentation.append("field=").append(key).append("(").append("value=").append(field.getValue()).append(", type=").append(field.getType()).append(")");
        }
        stringPresentation.append("}]");
        return stringPresentation.toString();
    }

    /* synthetic */ Extension(Builder builder, Extension extension) {
        this(builder);
    }

    public static class Builder {
        private String urn;
        private Map<String, Field> fields = new HashMap<String, Field>();

        public Builder(String urn) {
            this.urn = urn;
        }

        public Builder(Extension extension) {
            this.urn = extension.urn;
            this.fields.putAll(extension.fields);
        }

        public Builder setField(String fieldName, String value) {
            this.setField(fieldName, value, ExtensionFieldType.STRING);
            return this;
        }

        public Builder setField(String fieldName, Boolean value) {
            this.setField(fieldName, value, ExtensionFieldType.BOOLEAN);
            return this;
        }

        public Builder setField(String fieldName, ByteBuffer value) {
            this.setField(fieldName, value, ExtensionFieldType.BINARY);
            return this;
        }

        public Builder setField(String fieldName, BigInteger value) {
            this.setField(fieldName, value, ExtensionFieldType.INTEGER);
            return this;
        }

        public Builder setField(String fieldName, BigDecimal value) {
            this.setField(fieldName, value, ExtensionFieldType.DECIMAL);
            return this;
        }

        public Builder setField(String fieldName, Date value) {
            this.setField(fieldName, value, ExtensionFieldType.DATE_TIME);
            return this;
        }

        public Builder setField(String fieldName, URI value) {
            this.setField(fieldName, value, ExtensionFieldType.REFERENCE);
            return this;
        }

        public <T> Builder setField(String fieldName, T value, ExtensionFieldType<T> type) {
            if (fieldName == null || fieldName.isEmpty()) {
                throw new IllegalArgumentException("The field name can't be null or empty.");
            }
            if (value == null) {
                throw new IllegalArgumentException("The value can't be null.");
            }
            if (type == null) {
                throw new IllegalArgumentException("The type can't be null.");
            }
            this.fields.put(fieldName, new Field(type, type.toString(value)));
            return this;
        }

        public Builder removeField(String fieldName) {
            this.fields.remove(fieldName);
            return this;
        }

        public Extension build() {
            return new Extension(this, null);
        }
    }

    public static final class Field
    implements Serializable {
        private static final long serialVersionUID = 5733905110534921573L;
        private final ExtensionFieldType<?> type;
        private final String value;

        public Field(ExtensionFieldType<?> type, String value) {
            this.type = type;
            this.value = value;
        }

        public ExtensionFieldType<?> getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Field other = (Field)obj;
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "Field [type=" + this.type + ", value=" + this.value + "]";
        }
    }
}

