/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.query;

import com.google.common.base.Preconditions;
import org.osiam.client.query.QueryBuilder;

public class Query {
    private final String attributes;
    private final String filter;
    private final String sortBy;
    private final String sortOrder;
    private final long startIndex;
    private final int count;

    Query(QueryBuilder builder) {
        this.attributes = builder.attributes;
        this.filter = builder.filter;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.startIndex = builder.startIndex;
        this.count = builder.count;
    }

    public Query nextPage() {
        return new QueryBuilder(this).startIndex(this.startIndex + (long)this.count).build();
    }

    public Query previousPage() {
        Preconditions.checkState((this.startIndex > 1L ? 1 : 0) != 0, (Object)"StartIndex < 1 is not possible.");
        return new QueryBuilder(this).startIndex(this.startIndex - (long)this.count).build();
    }

    public String getAttributes() {
        return this.attributes;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return "Query [attributes=" + this.attributes + ", filter=" + this.filter + ", sortBy=" + this.sortBy + ", sortOrder=" + this.sortOrder + ", startIndex=" + this.startIndex + ", count=" + this.count + "]";
    }
}

