/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.oauth;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonInclude;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonProperty;
import org.osiam.client.exception.InvalidAttributeException;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Client {
    @JsonProperty
    private String id;
    @JsonProperty
    private int accessTokenValiditySeconds;
    @JsonProperty
    private int refreshTokenValiditySeconds;
    @JsonProperty
    private String redirectUri;
    @JsonProperty(value="client_secret")
    private String clientSecret;
    @JsonProperty(value="scope")
    private Set<String> scopes;
    @JsonProperty
    private Set<String> grants;
    @JsonProperty
    private boolean implicit;
    @JsonProperty
    private long validityInSeconds;

    private Client() {
    }

    public Client(Builder builder) {
        this.id = builder.clientId;
        this.accessTokenValiditySeconds = builder.accessTokenValiditySeconds;
        this.refreshTokenValiditySeconds = builder.refreshTokenValiditySeconds;
        this.redirectUri = builder.redirectUri;
        this.clientSecret = builder.clientSecret;
        this.scopes = builder.scopes;
        this.grants = builder.grants;
        this.implicit = builder.implicit;
        this.validityInSeconds = builder.validityInSeconds;
    }

    public String getId() {
        return this.id;
    }

    public int getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public int getRefreshTokenValiditySeconds() {
        return this.refreshTokenValiditySeconds;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public Set<String> getGrants() {
        return this.grants;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public long getValidityInSeconds() {
        return this.validityInSeconds;
    }

    public String toString() {
        return "Client{id='" + this.id + '\'' + ", accessTokenValiditySeconds=" + this.accessTokenValiditySeconds + ", refreshTokenValiditySeconds=" + this.refreshTokenValiditySeconds + ", redirectUri='" + this.redirectUri + '\'' + ", scopes=" + this.scopes + ", grants=" + this.grants + ", implicit=" + this.implicit + ", validityInSeconds=" + this.validityInSeconds + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client)o;
        return Objects.equals(this.accessTokenValiditySeconds, client.accessTokenValiditySeconds) && Objects.equals(this.refreshTokenValiditySeconds, client.refreshTokenValiditySeconds) && Objects.equals(this.implicit, client.implicit) && Objects.equals(this.validityInSeconds, client.validityInSeconds) && Objects.equals(this.id, client.id) && Objects.equals(this.redirectUri, client.redirectUri) && Objects.equals(this.clientSecret, client.clientSecret) && Objects.equals(this.scopes, client.scopes) && Objects.equals(this.grants, client.grants);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.accessTokenValiditySeconds, this.refreshTokenValiditySeconds, this.redirectUri, this.clientSecret, this.scopes, this.grants, this.implicit, this.validityInSeconds);
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private int accessTokenValiditySeconds;
        private int refreshTokenValiditySeconds;
        private String redirectUri;
        private Set<String> scopes = new HashSet<String>();
        private Set<String> grants = new HashSet<String>();
        private boolean implicit;
        private long validityInSeconds;

        public Builder(String clientId, String clientSecret) {
            if (Strings.isNullOrEmpty((String)clientId)) {
                throw new InvalidAttributeException("clientId must not be null or empty.");
            }
            if (Strings.isNullOrEmpty((String)clientSecret)) {
                throw new InvalidAttributeException("clientSecret must not be null or empty.");
            }
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        public Builder accessTokenValiditySeconds(int accessTokenValiditySeconds) {
            this.accessTokenValiditySeconds = accessTokenValiditySeconds;
            return this;
        }

        public Builder refreshTokenValiditySeconds(int refreshTokenValiditySeconds) {
            this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder grants(Set<String> grants) {
            this.grants = grants;
            return this;
        }

        public Builder implicit(boolean implicit) {
            this.implicit = implicit;
            return this;
        }

        public Builder validityInSeconds(long validityInSeconds) {
            this.validityInSeconds = validityInSeconds;
            return this;
        }

        public Client build() {
            return new Client(this);
        }
    }
}

