/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.List;
import org.osiam.bundled.com.fasterxml.jackson.databind.ObjectMapper;
import org.osiam.bundled.javax.ws.rs.client.ClientBuilder;
import org.osiam.bundled.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.osiam.bundled.org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.osiam.bundled.org.glassfish.jersey.client.ClientConfig;
import org.osiam.bundled.org.glassfish.jersey.client.RequestEntityProcessing;
import org.osiam.bundled.org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.osiam.client.AuthService;
import org.osiam.client.OsiamGroupService;
import org.osiam.client.OsiamUserService;
import org.osiam.client.Version;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.oauth.Client;
import org.osiam.client.oauth.Scope;
import org.osiam.client.query.Query;
import org.osiam.client.query.QueryBuilder;
import org.osiam.client.user.BasicUser;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.UpdateGroup;
import org.osiam.resources.scim.UpdateUser;
import org.osiam.resources.scim.User;

public class OsiamConnector {
    public static final ObjectMapper objectMapper = new ObjectMapper();
    private static final int DEFAULT_CONNECT_TIMEOUT = 2500;
    private static final int DEFAULT_READ_TIMEOUT = 5000;
    private static final boolean DEFAULT_LEGACY_SCHEMAS = false;
    private static final int DEFAULT_MAX_CONNECTIONS = 40;
    private static final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private static final org.osiam.bundled.javax.ws.rs.client.Client client = ClientBuilder.newClient(new ClientConfig().connectorProvider(new ApacheConnectorProvider()).property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED).property("jersey.config.apache.client.connectionManager", connectionManager).register(HttpAuthenticationFeature.basicBuilder().build()).property("jersey.config.client.connectTimeout", 2500).property("jersey.config.client.readTimeout", 5000));
    private AuthService authService;
    private OsiamUserService userService;
    private OsiamGroupService groupService;

    static {
        OsiamConnector.setMaxConnections(40);
    }

    private OsiamConnector(Builder builder) {
        Version version;
        String resourceEndpoint;
        String authEndpoint;
        if (!Strings.isNullOrEmpty((String)builder.endpoint)) {
            authEndpoint = builder.endpoint;
            resourceEndpoint = builder.endpoint;
            version = Version.OSIAM_3;
        } else {
            authEndpoint = builder.getAuthServiceEndpoint();
            resourceEndpoint = builder.getResourceServiceEndpoint();
            version = builder.legacySchemas ? Version.OSIAM_2_LEGACY_SCHEMAS : Version.OSIAM_2;
        }
        if (!Strings.isNullOrEmpty((String)authEndpoint)) {
            this.authService = new AuthService(authEndpoint, builder.clientId, builder.clientSecret, builder.clientRedirectUri, builder.connectTimeout, builder.readTimeout);
        }
        if (!Strings.isNullOrEmpty((String)resourceEndpoint)) {
            this.userService = new OsiamUserService(resourceEndpoint, builder.connectTimeout, builder.readTimeout, version);
            this.groupService = new OsiamGroupService(resourceEndpoint, builder.connectTimeout, builder.readTimeout, version);
        }
    }

    static org.osiam.bundled.javax.ws.rs.client.Client getClient() {
        return client;
    }

    public static void setConnectTimeout(int connectTimeout) {
        client.property("jersey.config.client.connectTimeout", connectTimeout);
    }

    public static void setReadTimeout(int readTimeout) {
        client.property("jersey.config.client.readTimeout", readTimeout);
    }

    public static void setMaxConnections(int maxConnections) {
        connectionManager.setMaxTotal(maxConnections);
        connectionManager.setDefaultMaxPerRoute(maxConnections);
    }

    public static void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        connectionManager.setDefaultMaxPerRoute(maxConnectionsPerRoute);
    }

    private AuthService getAuthService() {
        if (this.authService == null) {
            throw new IllegalStateException("OSIAM's endpoint(s) are not properly configured.");
        }
        return this.authService;
    }

    private OsiamUserService getUserService() {
        if (this.userService == null) {
            throw new IllegalStateException("OSIAM's endpoint(s) are not properly configured.");
        }
        return this.userService;
    }

    private OsiamGroupService getGroupService() {
        if (this.groupService == null) {
            throw new IllegalStateException("OSIAM's endpoint(s) are not properly configured.");
        }
        return this.groupService;
    }

    public User getUser(String id, AccessToken accessToken, String ... attributes) {
        return this.getUserService().getUser(id, accessToken, attributes);
    }

    public List<User> getAllUsers(AccessToken accessToken, String ... attributes) {
        return this.getUserService().getAllUsers(accessToken, attributes);
    }

    public SCIMSearchResult<User> searchUsers(Query query, AccessToken accessToken) {
        return this.getUserService().searchResources(query, accessToken);
    }

    @Deprecated
    public User getCurrentUser(AccessToken accessToken) {
        return this.getUserService().getCurrentUser(accessToken);
    }

    public User getMe(AccessToken accessToken, String ... attributes) {
        return this.getUserService().getMe(accessToken, attributes);
    }

    @Deprecated
    public BasicUser getCurrentUserBasic(AccessToken accessToken) {
        return this.getUserService().getCurrentUserBasic(accessToken);
    }

    public Group getGroup(String id, AccessToken accessToken, String ... attributes) {
        return this.getGroupService().getGroup(id, accessToken, attributes);
    }

    public List<Group> getAllGroups(AccessToken accessToken, String ... attributes) {
        return this.getGroupService().getAllGroups(accessToken, new String[0]);
    }

    public SCIMSearchResult<Group> searchGroups(Query query, AccessToken accessToken) {
        return this.getGroupService().searchGroups(query, accessToken);
    }

    public AccessToken refreshAccessToken(AccessToken accessToken, Scope ... scopes) {
        return this.getAuthService().refreshAccessToken(accessToken, scopes);
    }

    public URI getAuthorizationUri(Scope ... scopes) {
        return this.getAuthService().getAuthorizationUri(scopes);
    }

    public AccessToken retrieveAccessToken(Scope ... scopes) {
        return this.getAuthService().retrieveAccessToken(scopes);
    }

    public AccessToken retrieveAccessToken(String userName, String password, Scope ... scopes) {
        return this.getAuthService().retrieveAccessToken(userName, password, scopes);
    }

    public AccessToken retrieveAccessToken(String authCode) {
        return this.getAuthService().retrieveAccessToken(authCode);
    }

    public User createUser(User user, AccessToken accessToken) {
        return this.getUserService().createUser(user, accessToken);
    }

    public Group createGroup(Group group, AccessToken accessToken) {
        return this.getGroupService().createGroup(group, accessToken);
    }

    public void deleteGroup(String id, AccessToken accessToken) {
        this.getGroupService().deleteGroup(id, accessToken);
    }

    public void deleteUser(String id, AccessToken accessToken) {
        this.getUserService().deleteUser(id, accessToken);
    }

    @Deprecated
    public User updateUser(String id, UpdateUser updateUser, AccessToken accessToken) {
        return this.getUserService().updateUser(id, updateUser, accessToken);
    }

    public User replaceUser(String id, User user, AccessToken accessToken) {
        return this.getUserService().replaceUser(id, user, accessToken);
    }

    @Deprecated
    public Group updateGroup(String id, UpdateGroup updateGroup, AccessToken accessToken) {
        return this.getGroupService().updateGroup(id, updateGroup, accessToken);
    }

    public Group replaceGroup(String id, Group group, AccessToken accessToken) {
        return this.getGroupService().replaceGroup(id, group, accessToken);
    }

    public AccessToken validateAccessToken(AccessToken tokenToValidate) {
        return this.getAuthService().validateAccessToken(tokenToValidate);
    }

    public void revokeAccessToken(AccessToken tokenToRevoke) {
        this.getAuthService().revokeAccessToken(tokenToRevoke);
    }

    public void revokeAllAccessTokens(String id, AccessToken accessToken) {
        this.getAuthService().revokeAllAccessTokens(id, accessToken);
    }

    public Client getClient(String clientId, AccessToken accessToken) {
        return this.getAuthService().getClient(clientId, accessToken);
    }

    public List<Client> getClients(AccessToken accessToken) {
        return this.getAuthService().getClients(accessToken);
    }

    public Client createClient(Client client, AccessToken accessToken) {
        return this.getAuthService().createClient(client, accessToken);
    }

    public void deleteClient(String clientId, AccessToken accessToken) {
        this.getAuthService().deleteClient(clientId, accessToken);
    }

    public Client updateClient(String clientId, Client client, AccessToken accessToken) {
        return this.getAuthService().updateClient(clientId, client, accessToken);
    }

    public QueryBuilder createQueryBuilder() {
        return new QueryBuilder();
    }

    public QueryBuilder createQueryBuilder(Query original) {
        return new QueryBuilder(original);
    }

    /* synthetic */ OsiamConnector(Builder builder, OsiamConnector osiamConnector) {
        this(builder);
    }

    public static class Builder {
        private String endpoint;
        private String combinedEndpoint;
        private String authServiceEndpoint;
        private String resourceServiceEndpoint;
        private String clientId;
        private String clientSecret;
        private String clientRedirectUri;
        private int connectTimeout = 2500;
        private int readTimeout = 5000;
        private boolean legacySchemas = false;

        public Builder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            this.combinedEndpoint = null;
            this.authServiceEndpoint = null;
            this.resourceServiceEndpoint = null;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.combinedEndpoint = endpoint;
            this.endpoint = null;
            this.authServiceEndpoint = null;
            this.resourceServiceEndpoint = null;
            return this;
        }

        public Builder setAuthServerEndpoint(String endpoint) {
            this.authServiceEndpoint = endpoint;
            this.endpoint = null;
            this.combinedEndpoint = null;
            return this;
        }

        public Builder setResourceServerEndpoint(String endpoint) {
            this.resourceServiceEndpoint = endpoint;
            this.endpoint = null;
            this.combinedEndpoint = null;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setClientRedirectUri(String clientRedirectUri) {
            this.clientRedirectUri = clientRedirectUri;
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder withLegacySchemas(boolean legacySchemas) {
            this.legacySchemas = legacySchemas;
            return this;
        }

        public OsiamConnector build() {
            return new OsiamConnector(this, null);
        }

        private String getAuthServiceEndpoint() {
            if (!Strings.isNullOrEmpty((String)this.authServiceEndpoint)) {
                return this.authServiceEndpoint;
            }
            if (!Strings.isNullOrEmpty((String)this.combinedEndpoint)) {
                return String.valueOf(this.appendSlash(this.combinedEndpoint)) + "osiam-auth-server";
            }
            return null;
        }

        private String getResourceServiceEndpoint() {
            if (!Strings.isNullOrEmpty((String)this.resourceServiceEndpoint)) {
                return this.resourceServiceEndpoint;
            }
            if (!Strings.isNullOrEmpty((String)this.combinedEndpoint)) {
                return String.valueOf(this.appendSlash(this.combinedEndpoint)) + "osiam-resource-server";
            }
            return null;
        }

        private String appendSlash(String endpoint) {
            return !endpoint.endsWith("/") ? String.valueOf(endpoint) + "/" : endpoint;
        }
    }
}

