/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.glassfish.jersey.process.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osiam.bundled.javax.inject.Named;
import org.osiam.bundled.javax.inject.Qualifier;
import org.osiam.bundled.javax.inject.Singleton;
import org.osiam.bundled.org.glassfish.hk2.api.DynamicConfiguration;
import org.osiam.bundled.org.glassfish.hk2.api.Factory;
import org.osiam.bundled.org.glassfish.hk2.api.ServiceLocator;
import org.osiam.bundled.org.glassfish.hk2.utilities.binding.ScopedBindingBuilder;
import org.osiam.bundled.org.glassfish.jersey.internal.LocalizationMessages;
import org.osiam.bundled.org.glassfish.jersey.internal.inject.Injections;
import org.osiam.bundled.org.glassfish.jersey.internal.inject.Providers;
import org.osiam.bundled.org.glassfish.jersey.internal.util.ExtendedLogger;
import org.osiam.bundled.org.glassfish.jersey.internal.util.ReflectionHelper;
import org.osiam.bundled.org.glassfish.jersey.spi.ExecutorServiceProvider;
import org.osiam.bundled.org.glassfish.jersey.spi.ScheduledExecutorServiceProvider;

public final class ExecutorProviders {
    private static final ExtendedLogger LOGGER = new ExtendedLogger(Logger.getLogger(ExecutorProviders.class.getName()), Level.FINEST);

    private ExecutorProviders() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static void createInjectionBindings(ServiceLocator locator) {
        Map<Class<Annotation>, List<ExecutorServiceProvider>> executorProviderMap = ExecutorProviders.getQualifierToProviderMap(locator, ExecutorServiceProvider.class);
        DynamicConfiguration dc = Injections.getConfiguration(locator);
        for (Map.Entry<Class<Annotation>, List<ExecutorServiceProvider>> qualifierToProviders : executorProviderMap.entrySet()) {
            Class<Annotation> qualifierAnnotationClass = qualifierToProviders.getKey();
            Iterator<ExecutorServiceProvider> bucketProviderIterator = qualifierToProviders.getValue().iterator();
            ExecutorServiceProvider executorProvider = bucketProviderIterator.next();
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config(LocalizationMessages.USING_EXECUTOR_PROVIDER(executorProvider.getClass().getName(), qualifierAnnotationClass.getName()));
                if (bucketProviderIterator.hasNext()) {
                    StringBuilder msg = new StringBuilder(bucketProviderIterator.next().getClass().getName());
                    while (bucketProviderIterator.hasNext()) {
                        msg.append(", ").append(bucketProviderIterator.next().getClass().getName());
                    }
                    LOGGER.config(LocalizationMessages.IGNORED_EXECUTOR_PROVIDERS(msg.toString(), qualifierAnnotationClass.getName()));
                }
            }
            ScopedBindingBuilder<ExecutorService> bindingBuilder = Injections.newFactoryBinder(new ExecutorServiceFactory(executorProvider)).to(ExecutorService.class).in(Singleton.class);
            Annotation qualifier = executorProvider.getClass().getAnnotation(qualifierAnnotationClass);
            if (qualifier instanceof Named) {
                Injections.addBinding(bindingBuilder.named(((Named)qualifier).value()), dc);
                continue;
            }
            Injections.addBinding(bindingBuilder.qualifiedBy(qualifier), dc);
        }
        Map<Class<Annotation>, List<ScheduledExecutorServiceProvider>> schedulerProviderMap = ExecutorProviders.getQualifierToProviderMap(locator, ScheduledExecutorServiceProvider.class);
        for (Map.Entry<Class<Annotation>, List<ScheduledExecutorServiceProvider>> qualifierToProviders : schedulerProviderMap.entrySet()) {
            Annotation qualifier;
            Class<Annotation> qualifierAnnotationClass = qualifierToProviders.getKey();
            Iterator<ScheduledExecutorServiceProvider> bucketProviderIterator = qualifierToProviders.getValue().iterator();
            ScheduledExecutorServiceProvider executorProvider = bucketProviderIterator.next();
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config(LocalizationMessages.USING_SCHEDULER_PROVIDER(executorProvider.getClass().getName(), qualifierAnnotationClass.getName()));
                if (bucketProviderIterator.hasNext()) {
                    StringBuilder msg = new StringBuilder(bucketProviderIterator.next().getClass().getName());
                    while (bucketProviderIterator.hasNext()) {
                        msg.append(", ").append(bucketProviderIterator.next().getClass().getName());
                    }
                    LOGGER.config(LocalizationMessages.IGNORED_SCHEDULER_PROVIDERS(msg.toString(), qualifierAnnotationClass.getName()));
                }
            }
            ScopedBindingBuilder<ScheduledExecutorService> bindingBuilder = Injections.newFactoryBinder(new ScheduledExecutorServiceFactory(executorProvider)).in(Singleton.class).to(ScheduledExecutorService.class);
            if (!executorProviderMap.containsKey(qualifierAnnotationClass)) {
                bindingBuilder.to(ExecutorService.class);
            }
            if ((qualifier = executorProvider.getClass().getAnnotation(qualifierAnnotationClass)) instanceof Named) {
                Injections.addBinding(bindingBuilder.named(((Named)qualifier).value()), dc);
                continue;
            }
            Injections.addBinding(bindingBuilder.qualifiedBy(qualifier), dc);
        }
        dc.commit();
    }

    private static <T extends ExecutorServiceProvider> Map<Class<? extends Annotation>, List<T>> getQualifierToProviderMap(ServiceLocator locator, Class<T> providerClass) {
        Set<T> customExecutorProviders = Providers.getCustomProviders(locator, providerClass);
        Set<T> defaultExecutorProviders = Providers.getProviders(locator, providerClass);
        defaultExecutorProviders.removeAll(customExecutorProviders);
        LinkedList<T> executorProviders = new LinkedList<T>(customExecutorProviders);
        executorProviders.addAll(defaultExecutorProviders);
        Iterator providersIterator = executorProviders.iterator();
        HashMap<Class<Annotation>, List<T>> executorProviderMap = new HashMap<Class<Annotation>, List<T>>();
        while (providersIterator.hasNext()) {
            ExecutorServiceProvider provider = (ExecutorServiceProvider)providersIterator.next();
            for (Class<? extends Annotation> qualifier : ReflectionHelper.getAnnotationTypes(provider.getClass(), Qualifier.class)) {
                List<ExecutorServiceProvider> providersForQualifier;
                if (!executorProviderMap.containsKey(qualifier)) {
                    providersForQualifier = new LinkedList();
                    executorProviderMap.put(qualifier, providersForQualifier);
                } else {
                    providersForQualifier = (List)executorProviderMap.get(qualifier);
                }
                providersForQualifier.add(provider);
            }
        }
        return executorProviderMap;
    }

    private static class ScheduledExecutorServiceFactory
    implements Factory<ScheduledExecutorService> {
        private final ScheduledExecutorServiceProvider executorProvider;

        private ScheduledExecutorServiceFactory(ScheduledExecutorServiceProvider executorServiceProvider) {
            this.executorProvider = executorServiceProvider;
        }

        @Override
        public ScheduledExecutorService provide() {
            return this.executorProvider.getExecutorService();
        }

        @Override
        public void dispose(ScheduledExecutorService instance) {
            this.executorProvider.dispose(instance);
        }
    }

    private static class ExecutorServiceFactory
    implements Factory<ExecutorService> {
        private final ExecutorServiceProvider executorProvider;

        private ExecutorServiceFactory(ExecutorServiceProvider executorServiceProvider) {
            this.executorProvider = executorServiceProvider;
        }

        @Override
        public ExecutorService provide() {
            return this.executorProvider.getExecutorService();
        }

        @Override
        public void dispose(ExecutorService instance) {
            this.executorProvider.dispose(instance);
        }
    }
}

