/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.com.fasterxml.jackson.databind;

import java.io.IOException;
import java.util.Iterator;
import org.osiam.bundled.com.fasterxml.jackson.core.JsonGenerator;
import org.osiam.bundled.com.fasterxml.jackson.core.JsonProcessingException;
import org.osiam.bundled.com.fasterxml.jackson.databind.JavaType;
import org.osiam.bundled.com.fasterxml.jackson.databind.JsonMappingException;
import org.osiam.bundled.com.fasterxml.jackson.databind.SerializerProvider;
import org.osiam.bundled.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import org.osiam.bundled.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.osiam.bundled.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.osiam.bundled.com.fasterxml.jackson.databind.ser.PropertyWriter;
import org.osiam.bundled.com.fasterxml.jackson.databind.util.ClassUtil;
import org.osiam.bundled.com.fasterxml.jackson.databind.util.NameTransformer;

public abstract class JsonSerializer<T>
implements JsonFormatVisitable {
    public JsonSerializer<T> unwrappingSerializer(NameTransformer unwrapper) {
        return this;
    }

    public JsonSerializer<T> replaceDelegatee(JsonSerializer<?> delegatee) {
        throw new UnsupportedOperationException();
    }

    public JsonSerializer<?> withFilterId(Object filterId) {
        return this;
    }

    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonProcessingException;

    public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        Class<Object> clz = this.handledType();
        if (clz == null) {
            clz = value.getClass();
        }
        serializers.reportMappingProblem("Type id handling not implemented for type %s (by serializer of type %s)", clz.getName(), this.getClass().getName());
    }

    public Class<T> handledType() {
        return null;
    }

    @Deprecated
    public boolean isEmpty(T value) {
        return this.isEmpty(null, value);
    }

    public boolean isEmpty(SerializerProvider provider, T value) {
        return value == null;
    }

    public boolean usesObjectId() {
        return false;
    }

    public boolean isUnwrappingSerializer() {
        return false;
    }

    public JsonSerializer<?> getDelegatee() {
        return null;
    }

    public Iterator<PropertyWriter> properties() {
        return ClassUtil.emptyIterator();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType type) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectAnyFormat(type);
        }
    }

    public static abstract class None
    extends JsonSerializer<Object> {
    }
}

