/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.osiam.resources.exception.SCIMDataValidationException;
import org.osiam.resources.scim.Meta;

public abstract class Resource
implements Serializable {
    private static final long serialVersionUID = 1726103518645055449L;
    private final String id;
    private final String externalId;
    private final Meta meta;
    private final Set<String> schemas;

    Resource(String id, String externalId, Meta meta, Set<String> schemas) {
        this.id = id;
        this.externalId = externalId;
        this.meta = meta;
        if (schemas == null || schemas.isEmpty()) {
            throw new SCIMDataValidationException("Schemas cannot be null or empty!");
        }
        this.schemas = ImmutableSet.copyOf(schemas);
    }

    public String getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public Set<String> getSchemas() {
        return this.schemas;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static abstract class Builder {
        private String externalId;
        private String id;
        private Meta meta;
        private Set<String> schemas = new HashSet<String>();

        public Builder(Resource resource) {
            if (resource != null) {
                this.id = resource.id;
                this.externalId = resource.externalId;
                this.meta = resource.meta;
                this.schemas.addAll(resource.schemas);
            }
        }

        @Deprecated
        public Builder setSchemas(Set<String> schemas) {
            this.schemas = schemas;
            return this;
        }

        protected void addSchema(String schema) {
            if (this.schemas == null) {
                this.schemas = new HashSet<String>();
            }
            this.schemas.add(schema);
        }

        @Deprecated
        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        @Deprecated
        public Builder setMeta(Meta meta) {
            this.meta = meta;
            return this;
        }

        protected String getExternalId() {
            return this.externalId;
        }

        protected String getId() {
            return this.id;
        }

        protected Meta getMeta() {
            return this.meta;
        }

        protected Set<String> getSchemas() {
            return this.schemas;
        }

        public abstract <T> T build();
    }
}

