/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonCreator;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonIgnore;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonProperty;
import org.osiam.resources.data.ImageDataURI;
import org.osiam.resources.data.PhotoValueType;
import org.osiam.resources.exception.SCIMDataValidationException;
import org.osiam.resources.scim.MultiValuedAttribute;
import org.osiam.resources.scim.MultiValuedAttributeType;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public final class Photo
extends MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = -3801047382575408796L;
    private Type type;

    @JsonCreator
    public Photo(@JsonProperty(value="operation") String operation, @JsonProperty(value="value") String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="$ref") String reference, @JsonProperty(value="type") Type type) {
        super(operation, value, display, primary, reference);
        this.type = type;
    }

    private Photo(Builder builder) {
        super(builder);
        this.type = builder.type;
    }

    @Override
    @Deprecated
    public String getOperation() {
        return super.getOperation();
    }

    public URI getValueAsURI() {
        URI uri;
        try {
            uri = new URI(super.getValue());
        }
        catch (URISyntaxException e) {
            throw new SCIMDataValidationException(e.getMessage(), e);
        }
        return uri;
    }

    @JsonIgnore
    public ImageDataURI getValueAsImageDataURI() {
        return new ImageDataURI(super.getValue());
    }

    @JsonIgnore
    public PhotoValueType getValueType() {
        if (super.getValue().startsWith("data:image/") && super.getValue().contains(";base64,")) {
            try {
                this.getValueAsImageDataURI();
                return PhotoValueType.IMAGE_DATA_URI;
            }
            catch (Exception exception) {}
        }
        try {
            this.getValueAsURI();
            return PhotoValueType.URI;
        }
        catch (Exception exception) {
            return PhotoValueType.UNKNOWN;
        }
    }

    @Override
    public String getDisplay() {
        return super.getDisplay();
    }

    @Override
    public boolean isPrimary() {
        return super.isPrimary();
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Photo other = (Photo)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public String toString() {
        return "Photo [value=" + this.getValue() + ", type=" + this.type + ", primary=" + this.isPrimary() + ", operation=" + this.getOperation() + "]";
    }

    /* synthetic */ Photo(Builder builder, Photo photo) {
        this(builder);
    }

    public static class Builder
    extends MultiValuedAttribute.Builder {
        private Type type;

        public Builder() {
        }

        public Builder(Photo photo) {
            super(photo);
            this.type = photo.type;
        }

        @Override
        @Deprecated
        public Builder setOperation(String operation) {
            super.setOperation(operation);
            return this;
        }

        @Override
        public Builder setDisplay(String display) {
            super.setDisplay(display);
            return this;
        }

        @Override
        protected Builder setValue(String value) {
            super.setValue(value);
            return this;
        }

        public Builder setValue(URI uri) {
            super.setValue(uri.toString());
            return this;
        }

        public Builder setValue(ImageDataURI image) {
            super.setValue(image.toString());
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder setPrimary(boolean primary) {
            super.setPrimary(primary);
            return this;
        }

        @Override
        public Photo build() {
            return new Photo(this, null);
        }
    }

    public static class Type
    extends MultiValuedAttributeType {
        public static final Type PHOTO = new Type("photo");
        public static final Type THUMBNAIL = new Type("thumbnail");

        public Type(String value) {
            super(value);
        }
    }
}

