/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import com.google.common.base.Strings;
import java.io.Serializable;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonCreator;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonInclude;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonProperty;
import org.osiam.resources.exception.SCIMDataValidationException;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = 5910207539638462247L;
    private final String operation;
    private final String value;
    private final String display;
    private final boolean primary;
    @JsonProperty(value="$ref")
    private final String reference;

    @JsonCreator
    protected MultiValuedAttribute(@JsonProperty(value="operation") String operation, @JsonProperty(value="value") String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="$ref") String reference) {
        this.operation = operation;
        this.value = value;
        this.display = display;
        this.primary = primary;
        this.reference = reference;
    }

    protected MultiValuedAttribute(Builder builder) {
        this.value = builder.value;
        this.display = builder.display;
        this.primary = builder.primary;
        this.operation = builder.operation;
        this.reference = builder.reference;
    }

    protected String getValue() {
        return this.value;
    }

    protected String getDisplay() {
        return this.display;
    }

    protected boolean isPrimary() {
        return this.primary;
    }

    @Deprecated
    protected String getOperation() {
        return this.operation;
    }

    protected String getReference() {
        return this.reference;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.display == null ? 0 : this.display.hashCode());
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.primary ? 1231 : 1237);
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiValuedAttribute other = (MultiValuedAttribute)obj;
        if (this.display == null ? other.display != null : !this.display.equals(other.display)) {
            return false;
        }
        if (this.operation == null ? other.operation != null : !this.operation.equals(other.operation)) {
            return false;
        }
        if (this.primary != other.primary) {
            return false;
        }
        if (this.reference == null ? other.reference != null : !this.reference.equals(other.reference)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "MultiValuedAttribute [operation=" + this.operation + ", value=" + this.value + ", display=" + this.display + ", primary=" + this.primary + ", reference=" + this.reference + "]";
    }

    public static abstract class Builder {
        private String operation;
        private String value;
        private String display;
        private boolean primary;
        private String reference;

        protected Builder() {
        }

        protected Builder(MultiValuedAttribute multiValuedAttribute) {
            if (multiValuedAttribute == null) {
                throw new IllegalArgumentException("The given attribute can't be null.");
            }
            this.operation = multiValuedAttribute.getOperation();
            this.value = multiValuedAttribute.value;
            this.display = multiValuedAttribute.display;
            this.primary = multiValuedAttribute.primary;
        }

        protected Builder setValue(String value) {
            if (Strings.isNullOrEmpty((String)value)) {
                throw new SCIMDataValidationException("The given value can't be null or empty.");
            }
            this.value = value;
            return this;
        }

        protected Builder setDisplay(String display) {
            this.display = display;
            return this;
        }

        protected Builder setPrimary(boolean primary) {
            this.primary = primary;
            return this;
        }

        @Deprecated
        protected Builder setOperation(String operation) {
            this.operation = operation;
            return this;
        }

        @Deprecated
        protected Builder setReference(String reference) {
            this.reference = reference;
            return this;
        }

        protected abstract MultiValuedAttribute build();
    }
}

