/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.helper;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import org.osiam.bundled.com.fasterxml.jackson.core.JsonParser;
import org.osiam.bundled.com.fasterxml.jackson.databind.DeserializationContext;
import org.osiam.bundled.com.fasterxml.jackson.databind.DeserializationFeature;
import org.osiam.bundled.com.fasterxml.jackson.databind.JsonMappingException;
import org.osiam.bundled.com.fasterxml.jackson.databind.JsonNode;
import org.osiam.bundled.com.fasterxml.jackson.databind.ObjectMapper;
import org.osiam.bundled.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.osiam.bundled.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.osiam.resources.scim.Extension;
import org.osiam.resources.scim.ExtensionFieldType;
import org.osiam.resources.scim.User;

public class UserDeserializer
extends StdDeserializer<User> {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String schema;

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public UserDeserializer() {
        this("urn:ietf:params:scim:schemas:core:2.0:User");
    }

    public UserDeserializer(String schema) {
        super(User.class);
        this.schema = schema;
    }

    public UserDeserializer(Class<?> valueClass) {
        super(valueClass);
        this.schema = "urn:ietf:params:scim:schemas:core:2.0:User";
    }

    @Override
    public User deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode rootNode = (JsonNode)jp.readValueAsTree();
        User user = MAPPER.readValue(rootNode.traverse(), User.class);
        if (user.getSchemas() == null) {
            throw new JsonMappingException("Required field 'schemas' is missing");
        }
        if (user.getSchemas().size() == 1) {
            return user;
        }
        User.Builder builder = new User.Builder(user);
        for (String urn : user.getSchemas()) {
            JsonNode extensionNode;
            if (urn.equals(this.schema) || (extensionNode = rootNode.get(urn)) == null) continue;
            builder.addExtension(this.deserializeExtension(extensionNode, urn));
        }
        return builder.build();
    }

    public Extension deserializeExtension(JsonNode rootNode, String urn) throws IOException {
        if (urn == null || urn.isEmpty()) {
            throw new IllegalStateException("The URN cannot be null or empty");
        }
        if (rootNode.getNodeType() != JsonNodeType.OBJECT) {
            throw new JsonMappingException("Extension is of wrong JSON type");
        }
        Extension.Builder extensionBuilder = new Extension.Builder(urn);
        Iterator<Map.Entry<String, JsonNode>> fieldIterator = rootNode.fields();
        while (fieldIterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = fieldIterator.next();
            switch (entry.getValue().getNodeType()) {
                case BOOLEAN: {
                    Boolean boolValue = ExtensionFieldType.BOOLEAN.fromString(entry.getValue().asText());
                    extensionBuilder.setField(entry.getKey(), boolValue);
                    break;
                }
                case STRING: {
                    String stringValue = ExtensionFieldType.STRING.fromString(entry.getValue().asText());
                    extensionBuilder.setField(entry.getKey(), stringValue);
                    break;
                }
                case NUMBER: {
                    String numberValueAsString = entry.getValue().asText();
                    if (numberValueAsString.contains(".")) {
                        BigDecimal decimalValue = ExtensionFieldType.DECIMAL.fromString(numberValueAsString);
                        extensionBuilder.setField(entry.getKey(), decimalValue);
                        break;
                    }
                    BigInteger integerValue = ExtensionFieldType.INTEGER.fromString(numberValueAsString);
                    extensionBuilder.setField(entry.getKey(), integerValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("JSON type not supported: " + (Object)((Object)entry.getValue().getNodeType()));
                }
            }
        }
        return extensionBuilder.build();
    }
}

