/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.osiam.resources.data.DataURI;
import org.osiam.resources.exception.SCIMDataValidationException;

public class ImageDataURI
extends DataURI {
    public static final String IMAGE_MIME_TYPE = "data:image/";

    public ImageDataURI(String imageUri) {
        super(imageUri);
        if (!super.toString().startsWith(IMAGE_MIME_TYPE)) {
            throw new SCIMDataValidationException("The given URI '" + imageUri + "' is not a image data URI.");
        }
    }

    public ImageDataURI(URI imageUri) {
        super(imageUri);
        if (!super.toString().startsWith(IMAGE_MIME_TYPE)) {
            throw new SCIMDataValidationException("The given URI '" + imageUri.toString() + "' is not a image data URI.");
        }
    }

    public ImageDataURI(InputStream inputStream) throws IOException {
        super(inputStream);
        if (!super.toString().startsWith(IMAGE_MIME_TYPE)) {
            throw new SCIMDataValidationException("The given input stream is not an image.");
        }
    }
}

