/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import java.util.List;
import org.osiam.client.AbstractOsiamService;
import org.osiam.client.Version;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.query.Query;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.UpdateGroup;

class OsiamGroupService
extends AbstractOsiamService<Group> {
    private static final String LEGACY_SCHEMA = "urn:scim:schemas:core:2.0:Group";

    OsiamGroupService(String endpoint, int connectTimeout, int readTimeout, Version version) {
        super(endpoint, Group.class, connectTimeout, readTimeout, version);
    }

    Group getGroup(String id, AccessToken accessToken) {
        return (Group)this.getResource(id, accessToken);
    }

    List<Group> getAllGroups(AccessToken accessToken) {
        return this.getAllResources(accessToken);
    }

    SCIMSearchResult<Group> searchGroups(Query query, AccessToken accessToken) {
        return this.searchResources(query, accessToken);
    }

    void deleteGroup(String id, AccessToken accessToken) {
        this.deleteResource(id, accessToken);
    }

    Group createGroup(Group group, AccessToken accessToken) {
        return this.createResource(group, accessToken);
    }

    @Deprecated
    Group updateGroup(String id, UpdateGroup updateGroup, AccessToken accessToken) {
        return this.updateResource(id, updateGroup.getScimConformUpdateGroup(), accessToken);
    }

    @Deprecated
    Group updateGroup(String id, Group group, AccessToken accessToken) {
        return this.updateResource(id, group, accessToken);
    }

    Group replaceGroup(String id, Group group, AccessToken accessToken) {
        return this.replaceResource(id, group, accessToken);
    }

    @Override
    protected String getSchema() {
        return "urn:ietf:params:scim:schemas:core:2.0:Group";
    }

    @Override
    protected String getLegacySchema() {
        return LEGACY_SCHEMA;
    }
}

