/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.osiam.bundled.com.fasterxml.jackson.core.JsonProcessingException;
import org.osiam.bundled.com.fasterxml.jackson.core.type.TypeReference;
import org.osiam.bundled.javax.ws.rs.ProcessingException;
import org.osiam.bundled.javax.ws.rs.client.Entity;
import org.osiam.bundled.javax.ws.rs.client.WebTarget;
import org.osiam.bundled.javax.ws.rs.core.Form;
import org.osiam.bundled.javax.ws.rs.core.Response;
import org.osiam.bundled.javax.ws.rs.core.UriBuilder;
import org.osiam.bundled.javax.ws.rs.core.UriBuilderException;
import org.osiam.client.OsiamConnector;
import org.osiam.client.exception.BadCredentialsException;
import org.osiam.client.exception.BadRequestException;
import org.osiam.client.exception.ClientAlreadyExistsException;
import org.osiam.client.exception.ClientNotFoundException;
import org.osiam.client.exception.ConflictException;
import org.osiam.client.exception.ConnectionInitializationException;
import org.osiam.client.exception.ForbiddenException;
import org.osiam.client.exception.OAuthErrorMessage;
import org.osiam.client.exception.OsiamClientException;
import org.osiam.client.exception.UnauthorizedException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.oauth.Client;
import org.osiam.client.oauth.GrantType;
import org.osiam.client.oauth.Scope;

class AuthService {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer ";
    private static final String TOKEN_ENDPOINT = "/oauth/token";
    private static final String TOKEN_REVOCATION_ENDPOINT = "/token/revocation";
    private static final String TOKEN_VALIDATION_ENDPOINT = "/token/validation";
    private static final String CLIENT_ENDPOINT = "/Client";
    private final String endpoint;
    private final String clientId;
    private final String clientSecret;
    private final String clientRedirectUri;
    private final int connectTimeout;
    private final int readTimeout;
    private final WebTarget targetEndpoint;

    AuthService(String endpoint, String clientId, String clientSecret, String clientRedirectUri, int connectTimeout, int readTimeout) {
        this.endpoint = endpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientRedirectUri = clientRedirectUri;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.targetEndpoint = OsiamConnector.getClient().target(endpoint);
    }

    AccessToken retrieveAccessToken(Scope ... scopes) {
        String content;
        Response.StatusType status;
        this.ensureClientCredentialsAreSet();
        String formattedScopes = this.getScopesAsString(scopes);
        Form form = new Form();
        form.param("scope", formattedScopes);
        form.param("grant_type", GrantType.CLIENT_CREDENTIALS.getUrlParam());
        try {
            Response response = this.targetEndpoint.path(TOKEN_ENDPOINT).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).post(Entity.form(form));
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        this.checkAndHandleResponse(content, status, new AccessToken.Builder("n/a").build());
        return this.getAccessToken(content);
    }

    AccessToken retrieveAccessToken(String userName, String password, Scope ... scopes) {
        String content;
        Response.StatusType status;
        this.ensureClientCredentialsAreSet();
        String formattedScopes = this.getScopesAsString(scopes);
        Form form = new Form();
        form.param("scope", formattedScopes);
        form.param("grant_type", GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS.getUrlParam());
        form.param("username", userName);
        form.param("password", password);
        try {
            Response response = this.targetEndpoint.path(TOKEN_ENDPOINT).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).post(Entity.form(form));
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        this.checkAndHandleResponse(content, status, new AccessToken.Builder("n/a").build());
        return this.getAccessToken(content);
    }

    AccessToken retrieveAccessToken(String authCode) {
        String content;
        Response.StatusType status;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)authCode) ? 1 : 0) != 0, (Object)"The given authentication code can't be null.");
        this.ensureClientCredentialsAreSet();
        Form form = new Form();
        form.param("code", authCode);
        form.param("grant_type", "authorization_code");
        form.param("redirect_uri", this.clientRedirectUri);
        try {
            Response response = this.targetEndpoint.path(TOKEN_ENDPOINT).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).post(Entity.form(form));
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        if (status.getStatusCode() == Response.Status.BAD_REQUEST.getStatusCode()) {
            String errorMessage = this.extractErrorMessage(content, status);
            throw new ConflictException(errorMessage);
        }
        this.checkAndHandleResponse(content, status, new AccessToken.Builder("n/a").build());
        return this.getAccessToken(content);
    }

    private String getScopesAsString(Scope ... scopes) {
        StringBuilder scopeBuilder = new StringBuilder();
        Scope[] scopeArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            Scope scope = scopeArray[n2];
            scopeBuilder.append(scope.toString()).append(" ");
            ++n2;
        }
        return scopeBuilder.toString().trim();
    }

    AccessToken refreshAccessToken(AccessToken accessToken, Scope ... scopes) {
        String content;
        Response.StatusType status;
        Preconditions.checkArgument((accessToken != null ? 1 : 0) != 0, (Object)"The given accessToken code can't be null.");
        Preconditions.checkArgument((accessToken.getRefreshToken() != null ? 1 : 0) != 0, (Object)"Unable to perform a refresh_token_grant request without refresh token.");
        this.ensureClientCredentialsAreSet();
        String formattedScopes = this.getScopesAsString(scopes);
        Form form = new Form();
        form.param("scope", formattedScopes);
        form.param("grant_type", GrantType.REFRESH_TOKEN.getUrlParam());
        form.param("refresh_token", accessToken.getRefreshToken());
        try {
            Response response = this.targetEndpoint.path(TOKEN_ENDPOINT).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).post(Entity.form(form));
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        if (status.getStatusCode() == Response.Status.BAD_REQUEST.getStatusCode()) {
            throw new ConflictException(this.extractErrorMessage(content, status));
        }
        this.checkAndHandleResponse(content, status, accessToken);
        return this.getAccessToken(content);
    }

    URI getAuthorizationUri(Scope ... scopes) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.clientRedirectUri) ? 1 : 0) != 0, (Object)"Can't create the login uri: redirect URI was not set.");
        try {
            String formattedScopes = this.getScopesAsString(scopes);
            return UriBuilder.fromUri(this.endpoint).path("/oauth/authorize").queryParam("client_id", this.clientId).queryParam("response_type", "code").queryParam("redirect_uri", this.clientRedirectUri).queryParam("scope", formattedScopes).build(new Object[0]);
        }
        catch (IllegalArgumentException | UriBuilderException e) {
            throw new OsiamClientException("Unable to create redirect URI", e);
        }
    }

    AccessToken validateAccessToken(AccessToken tokenToValidate) {
        String content;
        Response.StatusType status;
        Preconditions.checkNotNull((Object)tokenToValidate, (Object)"The tokenToValidate must not be null.");
        try {
            Response response = this.targetEndpoint.path(TOKEN_VALIDATION_ENDPOINT).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).header(AUTHORIZATION_HEADER, BEARER + tokenToValidate.getToken()).post(Entity.json(""));
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        this.checkAndHandleResponse(content, status, tokenToValidate);
        return this.getAccessToken(content);
    }

    void revokeAccessToken(AccessToken tokenToRevoke) {
        String content;
        Response.StatusType status;
        try {
            Response response = this.targetEndpoint.path(TOKEN_REVOCATION_ENDPOINT).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).header(AUTHORIZATION_HEADER, BEARER + tokenToRevoke.getToken()).post(Entity.json(""));
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        this.checkAndHandleResponse(content, status, tokenToRevoke);
    }

    void revokeAllAccessTokens(String id, AccessToken accessToken) {
        String content;
        Response.StatusType status;
        try {
            Response response = this.targetEndpoint.path(TOKEN_REVOCATION_ENDPOINT).path(id).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).header(AUTHORIZATION_HEADER, BEARER + accessToken.getToken()).post(Entity.json(""));
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
    }

    Client createClient(Client client, AccessToken accessToken) {
        String createdClient;
        Response.StatusType status;
        String clientAsString;
        try {
            clientAsString = OsiamConnector.objectMapper.writeValueAsString(client);
        }
        catch (JsonProcessingException e) {
            throw new OsiamClientException(String.format("Unable to parse Client: %s", client), e);
        }
        try {
            Response response = this.targetEndpoint.path(CLIENT_ENDPOINT).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).header(AUTHORIZATION_HEADER, BEARER + accessToken.getToken()).post(Entity.json(clientAsString));
            status = response.getStatusInfo();
            createdClient = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        if (status.getStatusCode() == Response.Status.CONFLICT.getStatusCode()) {
            throw new ClientAlreadyExistsException(this.extractErrorMessage(createdClient, status));
        }
        this.checkAndHandleResponse(createdClient, status, accessToken);
        try {
            return OsiamConnector.objectMapper.readValue(createdClient, Client.class);
        }
        catch (IOException e) {
            throw new OsiamClientException(String.format("Unable to parse Client: %s", createdClient), e);
        }
    }

    Client getClient(String getClientId, AccessToken accessToken) {
        String client;
        Response.StatusType status;
        try {
            Response response = this.targetEndpoint.path(CLIENT_ENDPOINT).path(getClientId).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).header(AUTHORIZATION_HEADER, BEARER + accessToken.getToken()).get();
            status = response.getStatusInfo();
            client = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        this.checkAndHandleResponse(client, status, accessToken);
        try {
            return OsiamConnector.objectMapper.readValue(client, Client.class);
        }
        catch (IOException e) {
            throw new OsiamClientException(String.format("Unable to parse Client: %s", client), e);
        }
    }

    List<Client> getClients(AccessToken accessToken) {
        String clients;
        Response.StatusType status;
        try {
            Response response = this.targetEndpoint.path(CLIENT_ENDPOINT).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).header(AUTHORIZATION_HEADER, BEARER + accessToken.getToken()).get();
            status = response.getStatusInfo();
            clients = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        this.checkAndHandleResponse(clients, status, accessToken);
        try {
            return (List)OsiamConnector.objectMapper.readValue(clients, (TypeReference)new TypeReference<List<Client>>(){});
        }
        catch (IOException e) {
            throw new OsiamClientException(String.format("Unable to parse list of Clients: %s", clients), e);
        }
    }

    void deleteClient(String deleteClientId, AccessToken accessToken) {
        String content;
        Response.StatusType status;
        try {
            Response response = this.targetEndpoint.path(CLIENT_ENDPOINT).path(deleteClientId).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).header(AUTHORIZATION_HEADER, BEARER + accessToken.getToken()).delete();
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
    }

    Client updateClient(String updateClientId, Client client, AccessToken accessToken) {
        String clientResponse;
        Response.StatusType status;
        String clientAsString;
        try {
            clientAsString = OsiamConnector.objectMapper.writeValueAsString(client);
        }
        catch (JsonProcessingException e) {
            throw new OsiamClientException(String.format("Unable to parse Client: %s", client), e);
        }
        try {
            Response response = this.targetEndpoint.path(CLIENT_ENDPOINT).path(updateClientId).request("application/json").property("jersey.config.client.http.auth.username", this.clientId).property("jersey.config.client.http.auth.password", this.clientSecret).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).header(AUTHORIZATION_HEADER, BEARER + accessToken.getToken()).put(Entity.json(clientAsString));
            status = response.getStatusInfo();
            clientResponse = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw this.createGeneralConnectionInitializationException(e);
        }
        this.checkAndHandleResponse(clientResponse, status, accessToken);
        try {
            return OsiamConnector.objectMapper.readValue(clientResponse, Client.class);
        }
        catch (IOException e) {
            throw new OsiamClientException(String.format("Unable to parse Client: %s", clientResponse), e);
        }
    }

    private void checkAndHandleResponse(String content, Response.StatusType status, AccessToken accessToken) {
        if (status.getFamily() == Response.Status.Family.SUCCESSFUL) {
            return;
        }
        if (status.getStatusCode() == Response.Status.BAD_REQUEST.getStatusCode()) {
            String errorMessage = this.extractErrorMessage(content, status);
            if (errorMessage.equals("Bad credentials")) {
                throw new BadCredentialsException(errorMessage);
            }
            throw new BadRequestException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            String errorMessage = this.extractErrorMessage(content, status);
            throw new UnauthorizedException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.FORBIDDEN.getStatusCode()) {
            String errorMessage = this.extractErrorMessageForbidden(accessToken);
            throw new ForbiddenException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
            String errorMessage = this.extractErrorMessage(content, status);
            throw new ClientNotFoundException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.CONFLICT.getStatusCode()) {
            String errorMessage = this.extractErrorMessage(content, status);
            throw new ConflictException(errorMessage);
        }
        String errorMessage = this.extractErrorMessage(content, status);
        throw new ConnectionInitializationException(errorMessage);
    }

    private String extractErrorMessage(String content, Response.StatusType status) {
        try {
            OAuthErrorMessage error = OsiamConnector.objectMapper.readValue(content, OAuthErrorMessage.class);
            return error.getDescription();
        }
        catch (IOException iOException) {
            String errorMessage = String.format("Could not deserialize the error response for the HTTP status '%s'.", status.getReasonPhrase());
            if (content != null) {
                errorMessage = String.valueOf(errorMessage) + String.format(" Original response: %s", content);
            }
            return errorMessage;
        }
    }

    private String extractErrorMessageForbidden(AccessToken accessToken) {
        return "Insufficient scopes: " + accessToken.getScopes();
    }

    private AccessToken getAccessToken(String content) {
        try {
            return OsiamConnector.objectMapper.readValue(content, AccessToken.class);
        }
        catch (IOException e) {
            throw new OsiamClientException(String.format("Unable to parse access token: %s", content), e);
        }
    }

    private void ensureClientCredentialsAreSet() {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.clientId) ? 1 : 0) != 0, (Object)"The client id can't be null or empty.");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.clientSecret) ? 1 : 0) != 0, (Object)"The client secret can't be null or empty.");
    }

    private ConnectionInitializationException createGeneralConnectionInitializationException(Throwable e) {
        return new ConnectionInitializationException("Unable to retrieve access token.", e);
    }
}

