/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.glassfish.jersey.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osiam.bundled.javax.inject.Inject;
import org.osiam.bundled.javax.inject.Singleton;
import org.osiam.bundled.javax.ws.rs.core.Context;
import org.osiam.bundled.org.glassfish.hk2.api.ActiveDescriptor;
import org.osiam.bundled.org.glassfish.hk2.api.Factory;
import org.osiam.bundled.org.glassfish.hk2.api.Injectee;
import org.osiam.bundled.org.glassfish.hk2.api.InjectionResolver;
import org.osiam.bundled.org.glassfish.hk2.api.ServiceHandle;
import org.osiam.bundled.org.glassfish.hk2.api.ServiceLocator;
import org.osiam.bundled.org.glassfish.hk2.api.TypeLiteral;
import org.osiam.bundled.org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.osiam.bundled.org.glassfish.hk2.utilities.BuilderHelper;
import org.osiam.bundled.org.glassfish.hk2.utilities.InjecteeImpl;
import org.osiam.bundled.org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.osiam.bundled.org.glassfish.hk2.utilities.cache.Cache;
import org.osiam.bundled.org.glassfish.hk2.utilities.cache.Computable;
import org.osiam.bundled.org.glassfish.jersey.internal.inject.ForeignRequestScopeBridge;
import org.osiam.bundled.org.glassfish.jersey.internal.util.ReflectionHelper;
import org.osiam.bundled.org.glassfish.jersey.internal.util.collection.LazyValue;
import org.osiam.bundled.org.glassfish.jersey.internal.util.collection.Value;
import org.osiam.bundled.org.glassfish.jersey.internal.util.collection.Values;
import org.osiam.bundled.org.glassfish.jersey.process.internal.RequestScoped;

@Singleton
public class ContextInjectionResolver
implements InjectionResolver<Context> {
    @Inject
    private ServiceLocator serviceLocator;
    private final Cache<Injectee, ActiveDescriptor<?>> descriptorCache = new Cache(new Computable<Injectee, ActiveDescriptor<?>>(){

        @Override
        public ActiveDescriptor<?> compute(Injectee key) {
            return ContextInjectionResolver.this.serviceLocator.getInjecteeDescriptor(key);
        }
    });
    private final Cache<Injectee, Injectee> foreignRequestScopedInjecteeCache = new Cache<Injectee, Injectee>(new Computable<Injectee, Injectee>(){

        @Override
        public Injectee compute(Injectee injectee) {
            if (injectee.getParent() != null && Field.class.isAssignableFrom(injectee.getParent().getClass())) {
                Field f = (Field)injectee.getParent();
                if (((Set)ContextInjectionResolver.this.foreignRequestScopedComponents.get()).contains(f.getDeclaringClass())) {
                    Class<?> clazz = f.getType();
                    if (ContextInjectionResolver.this.serviceLocator.getServiceHandle(clazz, new Annotation[0]).getActiveDescriptor().getScopeAnnotation() == RequestScoped.class) {
                        AbstractActiveDescriptor descriptor = BuilderHelper.activeLink(clazz).to(clazz).in(RequestScoped.class).build();
                        return new DescriptorOverridingInjectee(injectee, descriptor);
                    }
                }
            }
            return injectee;
        }
    });
    LazyValue<Set<Class<?>>> foreignRequestScopedComponents = Values.lazy(new Value<Set<Class<?>>>(){

        @Override
        public Set<Class<?>> get() {
            return ContextInjectionResolver.this.getForeignRequestScopedComponents();
        }
    });

    @Override
    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        Type requiredType = injectee.getRequiredType();
        boolean isHk2Factory = ReflectionHelper.isSubClassOf(requiredType, Factory.class);
        Injectee newInjectee = isHk2Factory ? this.getFactoryInjectee(injectee, ReflectionHelper.getTypeArgument(requiredType, 0)) : this.foreignRequestScopedInjecteeCache.compute(injectee);
        ActiveDescriptor<?> ad = this.descriptorCache.compute(newInjectee);
        if (ad != null) {
            ServiceHandle<?> handle = this.serviceLocator.getServiceHandle(ad, newInjectee);
            if (isHk2Factory) {
                return this.asFactory(handle);
            }
            return handle.getService();
        }
        return null;
    }

    private Factory asFactory(final ServiceHandle handle) {
        return new Factory(){

            public Object provide() {
                return handle.getService();
            }

            public void dispose(Object instance) {
            }
        };
    }

    private Injectee getFactoryInjectee(Injectee injectee, Type requiredType) {
        return new RequiredTypeOverridingInjectee(injectee, requiredType);
    }

    @Override
    public boolean isConstructorParameterIndicator() {
        return true;
    }

    @Override
    public boolean isMethodParameterIndicator() {
        return false;
    }

    private Set<Class<?>> getForeignRequestScopedComponents() {
        List<ForeignRequestScopeBridge> scopeBridges = this.serviceLocator.getAllServices(ForeignRequestScopeBridge.class, new Annotation[0]);
        HashSet result = new HashSet();
        for (ForeignRequestScopeBridge bridge : scopeBridges) {
            Set<Class<?>> requestScopedComponents = bridge.getRequestScopedComponents();
            if (requestScopedComponents == null) continue;
            result.addAll(requestScopedComponents);
        }
        return result;
    }

    private static class DescriptorOverridingInjectee
    extends InjecteeImpl {
        private static final long serialVersionUID = -3740895548611880189L;

        private DescriptorOverridingInjectee(Injectee injectee, ActiveDescriptor descriptor) {
            super(injectee);
            this.setInjecteeDescriptor(descriptor);
        }
    }

    private static class RequiredTypeOverridingInjectee
    extends InjecteeImpl {
        private static final long serialVersionUID = -3740895548611880187L;

        private RequiredTypeOverridingInjectee(Injectee injectee, Type requiredType) {
            super(injectee);
            this.setRequiredType(requiredType);
        }
    }

    public static final class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bind(ContextInjectionResolver.class).to(new TypeLiteral<InjectionResolver<Context>>(){}).in(Singleton.class);
        }
    }
}

