/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.jersey.repackaged.com.google.common.collect;

import java.io.Serializable;
import java.util.Map;
import org.osiam.bundled.javax.annotation.Nullable;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.ImmutableAsList;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.ImmutableCollection;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.ImmutableList;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.ImmutableMap;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.ImmutableSet;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.UnmodifiableIterator;

final class ImmutableMapKeySet<K, V>
extends ImmutableSet<K> {
    private final ImmutableMap<K, V> map;

    ImmutableMapKeySet(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<K> iterator() {
        return this.asList().iterator();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.map.containsKey(object);
    }

    @Override
    ImmutableList<K> createAsList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map.entrySet())).asList();
        return new ImmutableAsList<K>(){

            @Override
            public K get(int index) {
                return ((Map.Entry)entryList.get(index)).getKey();
            }

            @Override
            ImmutableCollection<K> delegateCollection() {
                return ImmutableMapKeySet.this;
            }
        };
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    Object writeReplace() {
        return new KeySetSerializedForm<K>(this.map);
    }

    private static class KeySetSerializedForm<K>
    implements Serializable {
        final ImmutableMap<K, ?> map;

        KeySetSerializedForm(ImmutableMap<K, ?> map) {
            this.map = map;
        }
    }
}

