/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import java.util.List;
import org.osiam.client.AbstractOsiamService;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.query.Query;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.UpdateGroup;

class OsiamGroupService
extends AbstractOsiamService<Group> {
    static final String LEGACY_SCHEMA = "urn:scim:schemas:core:2.0:Group";

    private OsiamGroupService(Builder builder) {
        super(builder);
    }

    public Group getGroup(String id, AccessToken accessToken) {
        return (Group)this.getResource(id, accessToken);
    }

    public List<Group> getAllGroups(AccessToken accessToken) {
        return this.getAllResources(accessToken);
    }

    public SCIMSearchResult<Group> searchGroups(Query query, AccessToken accessToken) {
        return this.searchResources(query, accessToken);
    }

    public void deleteGroup(String id, AccessToken accessToken) {
        this.deleteResource(id, accessToken);
    }

    public Group createGroup(Group group, AccessToken accessToken) {
        return this.createResource(group, accessToken);
    }

    public Group updateGroup(String id, UpdateGroup updateGroup, AccessToken accessToken) {
        return this.updateResource(id, updateGroup.getScimConformUpdateGroup(), accessToken);
    }

    public Group updateGroup(String id, Group group, AccessToken accessToken) {
        return this.updateResource(id, group, accessToken);
    }

    public Group replaceGroup(String id, Group group, AccessToken accessToken) {
        return this.replaceResource(id, group, accessToken);
    }

    @Override
    protected String getSchema() {
        return "urn:ietf:params:scim:schemas:core:2.0:Group";
    }

    @Override
    protected String getLegacySchema() {
        return LEGACY_SCHEMA;
    }

    public static class Builder
    extends AbstractOsiamService.Builder<Group> {
        public Builder(String endpoint) {
            super(endpoint);
        }

        public Builder withConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder withLegacySchemas(boolean legacySchemas) {
            this.legacySchemas = legacySchemas;
            return this;
        }

        public OsiamGroupService build() {
            return new OsiamGroupService(this);
        }
    }
}

