/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import org.osiam.bundled.javax.ws.rs.ProcessingException;
import org.osiam.bundled.javax.ws.rs.client.Entity;
import org.osiam.bundled.javax.ws.rs.client.WebTarget;
import org.osiam.bundled.javax.ws.rs.core.Response;
import org.osiam.client.OsiamConnector;
import org.osiam.client.exception.ConflictException;
import org.osiam.client.exception.ConnectionInitializationException;
import org.osiam.client.exception.ForbiddenException;
import org.osiam.client.exception.NoResultException;
import org.osiam.client.exception.OAuthErrorMessage;
import org.osiam.client.exception.OsiamClientException;
import org.osiam.client.exception.OsiamRequestException;
import org.osiam.client.exception.UnauthorizedException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.query.Query;
import org.osiam.client.query.QueryBuilder;
import org.osiam.resources.helper.UserDeserializer;
import org.osiam.resources.scim.ErrorResponse;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.Resource;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.User;

abstract class AbstractOsiamService<T extends Resource> {
    protected static final String CONNECTION_SETUP_ERROR_STRING = "Cannot connect to OSIAM";
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String BEARER = "Bearer ";
    private final Class<T> type;
    private final String typeName;
    private final int connectTimeout;
    private final int readTimeout;
    private final boolean legacySchemas;
    protected final WebTarget targetEndpoint;

    protected AbstractOsiamService(Builder<T> builder) {
        this.type = ((Builder)builder).type;
        this.typeName = ((Builder)builder).typeName;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.legacySchemas = builder.legacySchemas;
        UserDeserializer userDeserializer = this.legacySchemas ? new UserDeserializer("urn:scim:schemas:core:2.0:User") : new UserDeserializer();
        SimpleModule userDeserializerModule = new SimpleModule("userDeserializerModule", Version.unknownVersion()).addDeserializer(User.class, (JsonDeserializer)userDeserializer);
        OsiamConnector.objectMapper.registerModule((Module)userDeserializerModule);
        this.targetEndpoint = OsiamConnector.getClient().target(((Builder)builder).endpoint);
    }

    protected T getResource(String id, AccessToken accessToken) {
        String content;
        Response.StatusType status;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"The given id must not be null nor empty.");
        AbstractOsiamService.checkAccessTokenIsNotNull(accessToken);
        try {
            Response response = this.targetEndpoint.path(this.typeName + "s").path(id).request("application/json").header(AUTHORIZATION, BEARER + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).get();
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
        return this.mapToResource(content);
    }

    protected List<T> getAllResources(AccessToken accessToken) {
        Query query = new QueryBuilder().count(Integer.MAX_VALUE).build();
        return this.searchResources(query, accessToken).getResources();
    }

    protected SCIMSearchResult<T> searchResources(Query query, AccessToken accessToken) {
        String content;
        Response.StatusType status;
        Preconditions.checkNotNull((Object)query, (Object)"The given query must not be null.");
        AbstractOsiamService.checkAccessTokenIsNotNull(accessToken);
        try {
            Response response = this.targetEndpoint.path(this.typeName + "s").queryParam("attributes", query.getAttributes()).queryParam("filter", query.getFilter()).queryParam("sortBy", query.getSortBy()).queryParam("sortOrder", query.getSortOrder()).queryParam("startIndex", query.getStartIndex() != 1L ? Long.valueOf(query.getStartIndex()) : null).queryParam("count", query.getCount() != 100 ? Integer.valueOf(query.getCount()) : null).request("application/json").header(AUTHORIZATION, BEARER + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).get();
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
        try {
            JavaType queryResultType = TypeFactory.defaultInstance().constructParametricType(SCIMSearchResult.class, new Class[]{this.type});
            return (SCIMSearchResult)OsiamConnector.objectMapper.readValue(content, queryResultType);
        }
        catch (IOException e) {
            throw new OsiamClientException(String.format("Unable to deserialize search result: %s", content), e);
        }
    }

    protected void deleteResource(String id, AccessToken accessToken) {
        String content;
        Response.StatusType status;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"The given id must not be null nor empty.");
        AbstractOsiamService.checkAccessTokenIsNotNull(accessToken);
        try {
            Response response = this.targetEndpoint.path(this.typeName + "s").path(id).request("application/json").header(AUTHORIZATION, BEARER + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).delete();
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
    }

    protected T createResource(T resource, AccessToken accessToken) {
        String content;
        Response.StatusType status;
        String resourceAsString;
        Preconditions.checkNotNull(resource, (String)"The given %s must not be null nor empty.", (Object[])new Object[]{this.typeName});
        AbstractOsiamService.checkAccessTokenIsNotNull(accessToken);
        try {
            resourceAsString = this.mapToString(resource);
        }
        catch (JsonProcessingException | ClassCastException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        try {
            Response response = this.targetEndpoint.path(this.typeName + "s").request("application/json").header(AUTHORIZATION, BEARER + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).post(Entity.json(resourceAsString));
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
        return this.mapToResource(content);
    }

    protected T updateResource(String id, T resource, AccessToken accessToken) {
        return this.modifyResource(id, resource, "PATCH", accessToken);
    }

    protected T replaceResource(String id, T resource, AccessToken accessToken) {
        return this.modifyResource(id, resource, "PUT", accessToken);
    }

    private T modifyResource(String id, T resource, String method, AccessToken accessToken) {
        String content;
        Response.StatusType status;
        String resourceAsString;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"The given id must not be null nor empty.");
        Preconditions.checkNotNull(resource, (String)"The given %s must not be null nor empty.", (Object[])new Object[]{this.typeName});
        AbstractOsiamService.checkAccessTokenIsNotNull(accessToken);
        try {
            resourceAsString = this.mapToString(resource);
        }
        catch (JsonProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        try {
            Response response = this.targetEndpoint.path(this.typeName + "s").path(id).request("application/json").header(AUTHORIZATION, BEARER + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).method(method, Entity.json(resourceAsString));
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
        return this.mapToResource(content);
    }

    private T mapToResource(String content) {
        return (T)((Resource)this.mapToType(content, this.type));
    }

    protected <U> U mapToType(String content, Class<U> type) {
        try {
            if (this.legacySchemas && (type == User.class || type == Group.class)) {
                ObjectNode resourceNode = (ObjectNode)OsiamConnector.objectMapper.readTree(content);
                this.switchToLegacySchema(resourceNode);
                return (U)OsiamConnector.objectMapper.readValue(OsiamConnector.objectMapper.treeAsTokens((TreeNode)resourceNode), type);
            }
            return (U)OsiamConnector.objectMapper.readValue(content, type);
        }
        catch (IOException | ClassCastException e) {
            throw new OsiamClientException(String.format("Unable to parse %s: %s", this.typeName, content), e);
        }
    }

    private String mapToString(T resource) throws JsonProcessingException {
        if (this.legacySchemas) {
            ObjectNode resourceNode = (ObjectNode)OsiamConnector.objectMapper.valueToTree(resource);
            this.switchToLegacySchema(resourceNode);
            return resourceNode.toString();
        }
        return OsiamConnector.objectMapper.writeValueAsString(resource);
    }

    private void switchToLegacySchema(ObjectNode resourceNode) {
        ArrayNode schemas = (ArrayNode)resourceNode.get("schemas");
        for (int i = 0; i < schemas.size(); ++i) {
            if (!this.getSchema().equals(schemas.get(i).textValue())) continue;
            schemas.remove(i);
        }
        schemas.add(this.getLegacySchema());
    }

    protected abstract String getSchema();

    protected abstract String getLegacySchema();

    protected void checkAndHandleResponse(String content, Response.StatusType status, AccessToken accessToken) {
        if (status.getFamily() == Response.Status.Family.SUCCESSFUL) {
            return;
        }
        if (status.getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            String errorMessage = this.extractErrorMessageUnauthorized(content, status);
            throw new UnauthorizedException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.BAD_REQUEST.getStatusCode()) {
            String errorMessage = this.extractErrorMessage(content, status);
            throw new ConflictException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
            String errorMessage = this.extractErrorMessage(content, status);
            throw new NoResultException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.FORBIDDEN.getStatusCode()) {
            String errorMessage = this.extractErrorMessageForbidden(accessToken);
            throw new ForbiddenException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.CONFLICT.getStatusCode()) {
            String errorMessage = this.extractErrorMessage(content, status);
            throw new ConflictException(errorMessage);
        }
        String errorMessage = this.extractErrorMessageDefault(content, status);
        throw new OsiamRequestException(status.getStatusCode(), errorMessage);
    }

    protected String extractErrorMessageForbidden(AccessToken accessToken) {
        return "Insufficient scopes: " + accessToken.getScopes();
    }

    protected String extractErrorMessageUnauthorized(String content, Response.StatusType status) {
        return this.extractErrorMessage(content, status);
    }

    protected String extractErrorMessageDefault(String content, Response.StatusType status) {
        return this.extractErrorMessage(content, status);
    }

    protected String extractErrorMessage(String content, Response.StatusType status) {
        String message = this.legacySchemas ? this.getScimErrorMessageLegacy(content) : this.getScimErrorMessage(content);
        if (message == null) {
            message = this.getOAuthErrorMessage(content);
        }
        if (message == null) {
            message = String.format("Could not deserialize the error response for the HTTP status '%s'.", status.getReasonPhrase());
            if (content != null) {
                message = message + String.format(" Original response: %s", content);
            }
        }
        return message;
    }

    private String getScimErrorMessage(String content) {
        try {
            ErrorResponse error = (ErrorResponse)OsiamConnector.objectMapper.readValue(content, ErrorResponse.class);
            return error.getDetail();
        }
        catch (IOException | ProcessingException e) {
            return null;
        }
    }

    private String getScimErrorMessageLegacy(String content) {
        try {
            Map error = (Map)OsiamConnector.objectMapper.readValue(content, (TypeReference)new TypeReference<Map<String, String>>(){});
            return (String)error.get("description");
        }
        catch (IOException | ProcessingException e) {
            return null;
        }
    }

    private String getOAuthErrorMessage(String content) {
        try {
            OAuthErrorMessage error = (OAuthErrorMessage)OsiamConnector.objectMapper.readValue(content, OAuthErrorMessage.class);
            return error.getDescription();
        }
        catch (IOException | ProcessingException e) {
            return null;
        }
    }

    protected static void checkAccessTokenIsNotNull(AccessToken accessToken) {
        Preconditions.checkNotNull((Object)accessToken, (Object)"The given accessToken must not be null.");
    }

    protected int getConnectTimeout() {
        return this.connectTimeout;
    }

    protected int getReadTimeout() {
        return this.readTimeout;
    }

    protected static class Builder<T> {
        private String endpoint;
        private Class<T> type;
        private String typeName;
        protected int connectTimeout = 2500;
        protected int readTimeout = 5000;
        protected boolean legacySchemas = false;

        protected Builder(String endpoint) {
            this.endpoint = endpoint;
            this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.typeName = this.type.getSimpleName();
        }
    }
}

