/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.jvnet.hk2.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.WeakHashMap;
import org.osiam.bundled.javassist.util.proxy.MethodHandler;
import org.osiam.bundled.javassist.util.proxy.ProxyFactory;
import org.osiam.bundled.javassist.util.proxy.ProxyObject;
import org.osiam.bundled.org.glassfish.hk2.api.ActiveDescriptor;
import org.osiam.bundled.org.glassfish.hk2.api.MultiException;
import org.osiam.bundled.org.glassfish.hk2.api.ProxyCtl;
import org.osiam.bundled.org.glassfish.hk2.api.ServiceHandle;
import org.osiam.bundled.org.jvnet.hk2.internal.DelegatingClassLoader;
import org.osiam.bundled.org.jvnet.hk2.internal.MethodInterceptorImpl;
import org.osiam.bundled.org.jvnet.hk2.internal.MethodInterceptorInvocationHandler;
import org.osiam.bundled.org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.osiam.bundled.org.jvnet.hk2.internal.Utilities;

public class ProxyUtilities {
    private static final Object proxyCreationLock = new Object();
    private static final WeakHashMap<WeakDelegatingCacheEntry, Object> delegatingLoaderSet = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T secureCreate(final Class<?> superclass, final Class<?>[] interfaces, final MethodHandler callback, boolean useJDKProxy) {
        DelegatingClassLoader myLoader;
        WeakHashMap<WeakDelegatingCacheEntry, Object> weakHashMap = delegatingLoaderSet;
        synchronized (weakHashMap) {
            WeakDelegatingCacheEntry key = new WeakDelegatingCacheEntry(superclass.getClassLoader());
            WeakDelegatingCacheEntry found = null;
            for (WeakDelegatingCacheEntry entry : delegatingLoaderSet.keySet()) {
                if (!key.equals(entry)) continue;
                found = entry;
                break;
            }
            if (found == null) {
                found = key;
                delegatingLoaderSet.put(found, null);
            }
            myLoader = found.getDelegator();
        }
        final DelegatingClassLoader delegatingLoader = myLoader;
        if (useJDKProxy) {
            return AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    return Proxy.newProxyInstance(delegatingLoader, interfaces, (InvocationHandler)new MethodInterceptorInvocationHandler(callback));
                }
            });
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            /*
             * Loose catch block
             * Enabled aggressive exception aggregation
             */
            @Override
            public T run() {
                Object object = proxyCreationLock;
                synchronized (object) {
                    ProxyFactory.ClassLoaderProvider originalProvider = ProxyFactory.classLoaderProvider;
                    ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

                        @Override
                        public ClassLoader get(ProxyFactory arg0) {
                            return delegatingLoader;
                        }
                    };
                    ProxyFactory proxyFactory = new ProxyFactory();
                    proxyFactory.setInterfaces(interfaces);
                    proxyFactory.setSuperclass(superclass);
                    Class proxyClass = proxyFactory.createClass();
                    Object proxy = proxyClass.newInstance();
                    ((ProxyObject)proxy).setHandler(callback);
                    Object t = proxy;
                    return t;
                    {
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                    finally {
                        ProxyFactory.classLoaderProvider = originalProvider;
                    }
                }
            }
        });
    }

    public static <T> T generateProxy(Class<?> requestedClass, ServiceLocatorImpl locator, ActiveDescriptor<T> root, ServiceHandle<T> handle) {
        T proxy;
        Class[] iFaces;
        Class<?> proxyClass;
        boolean isInterface;
        boolean bl = isInterface = requestedClass == null ? false : requestedClass.isInterface();
        if (isInterface) {
            proxyClass = requestedClass;
            iFaces = new Class[]{proxyClass, ProxyCtl.class};
        } else {
            proxyClass = Utilities.getFactoryAwareImplementationClass(root);
            iFaces = Utilities.getInterfacesForProxy(root.getContractTypes());
        }
        try {
            proxy = ProxyUtilities.secureCreate(proxyClass, iFaces, new MethodInterceptorImpl(locator, root, handle), isInterface);
        }
        catch (Throwable th) {
            IllegalArgumentException addMe = new IllegalArgumentException("While attempting to create a Proxy for " + proxyClass.getName() + " in proxiable scope " + root.getScope() + " an error occured while creating the proxy");
            if (th instanceof MultiException) {
                MultiException me = (MultiException)th;
                me.addError(addMe);
                throw me;
            }
            MultiException me = new MultiException(th);
            me.addError(addMe);
            throw me;
        }
        return proxy;
    }

    private static class WeakDelegatingCacheEntry {
        private final ClassLoader key;
        private DelegatingClassLoader loader;

        private WeakDelegatingCacheEntry(ClassLoader key) {
            this.key = key;
        }

        private DelegatingClassLoader getDelegator() {
            if (this.loader != null) {
                return this.loader;
            }
            final WeakDelegatingCacheEntry backPointer = this;
            this.loader = AccessController.doPrivileged(new PrivilegedAction<DelegatingClassLoader>(){

                @Override
                public DelegatingClassLoader run() {
                    return new DelegatingClassLoader(WeakDelegatingCacheEntry.this.key, backPointer, ProxyFactory.class.getClassLoader(), ProxyCtl.class.getClassLoader());
                }
            });
            return this.loader;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof WeakDelegatingCacheEntry)) {
                return false;
            }
            WeakDelegatingCacheEntry other = (WeakDelegatingCacheEntry)o;
            return this.key.equals(other.key);
        }
    }
}

