/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.query;

import org.osiam.bundled.org.joda.time.DateTime;
import org.osiam.bundled.org.joda.time.format.DateTimeFormat;
import org.osiam.bundled.org.joda.time.format.DateTimeFormatter;
import org.osiam.client.query.Query;

public class QueryBuilder {
    public static final long DEFAULT_START_INDEX = 1L;
    public static final int DEFAULT_COUNT = 100;
    public static final int MAX_COUNT = 100;
    String attributes;
    String filter;
    String sortBy;
    String sortOrder;
    long startIndex = 1L;
    int count = 100;

    public QueryBuilder() {
    }

    public QueryBuilder(Query original) {
        this.attributes = original.getAttributes();
        this.filter = original.getFilter();
        this.sortBy = original.getSortBy();
        this.sortOrder = original.getSortOrder();
        this.startIndex = original.getStartIndex();
        this.count = original.getCount();
    }

    public Query build() {
        return new Query(this);
    }

    public QueryBuilder attributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public QueryBuilder filter(String filter) {
        this.filter = filter;
        return this;
    }

    public QueryBuilder ascending(String sortByAttribute) {
        this.sortBy = sortByAttribute;
        this.sortOrder = "ascending";
        return this;
    }

    public QueryBuilder descending(String sortByAttribute) {
        this.sortBy = sortByAttribute;
        this.sortOrder = "descending";
        return this;
    }

    public QueryBuilder startIndex(long startIndex) {
        this.startIndex = startIndex < 1L ? 1L : startIndex;
        return this;
    }

    public QueryBuilder count(int count) {
        this.count = count < 1 ? 100 : count;
        return this;
    }

    public static String getScimConformFormatedDateTime(DateTime dateTime) {
        DateTimeFormatter dateFormat = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
        return dateFormat.print(dateTime);
    }
}

