/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.glassfish.hk2.utilities.reflection.internal;

import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.osiam.bundled.javax.annotation.PostConstruct;
import org.osiam.bundled.javax.annotation.PreDestroy;
import org.osiam.bundled.org.glassfish.hk2.utilities.cache.Computable;
import org.osiam.bundled.org.glassfish.hk2.utilities.cache.HybridCacheEntry;
import org.osiam.bundled.org.glassfish.hk2.utilities.cache.LRUHybridCache;
import org.osiam.bundled.org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.osiam.bundled.org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.osiam.bundled.org.glassfish.hk2.utilities.reflection.Pretty;
import org.osiam.bundled.org.glassfish.hk2.utilities.reflection.internal.MethodWrapperImpl;

public class ClassReflectionHelperImpl
implements ClassReflectionHelper {
    private final int MAX_CACHE_SIZE = 200;
    private static final String CONVENTION_POST_CONSTRUCT = "postConstruct";
    private static final String CONVENTION_PRE_DESTROY = "preDestroy";
    private static final Set<MethodWrapper> OBJECT_METHODS = ClassReflectionHelperImpl.getObjectMethods();
    private static final Set<Field> OBJECT_FIELDS = ClassReflectionHelperImpl.getObjectFields();
    private final LRUHybridCache<LifecycleKey, Method> postConstructCache = new LRUHybridCache<LifecycleKey, Method>(200, new Computable<LifecycleKey, HybridCacheEntry<Method>>(){

        @Override
        public HybridCacheEntry<Method> compute(LifecycleKey key) {
            return ClassReflectionHelperImpl.this.postConstructCache.createCacheEntry(key, ClassReflectionHelperImpl.this.getPostConstructMethod(key.clazz, key.matchingClass), false);
        }
    });
    private final LRUHybridCache<LifecycleKey, Method> preDestroyCache = new LRUHybridCache<LifecycleKey, Method>(200, new Computable<LifecycleKey, HybridCacheEntry<Method>>(){

        @Override
        public HybridCacheEntry<Method> compute(LifecycleKey key) {
            return ClassReflectionHelperImpl.this.preDestroyCache.createCacheEntry(key, ClassReflectionHelperImpl.this.getPreDestroyMethod(key.clazz, key.matchingClass), false);
        }
    });
    private final LRUHybridCache<Class<?>, Set<MethodWrapper>> methodCache = new LRUHybridCache(200, new Computable<Class<?>, HybridCacheEntry<Set<MethodWrapper>>>(){

        @Override
        public HybridCacheEntry<Set<MethodWrapper>> compute(Class<?> key) {
            return ClassReflectionHelperImpl.this.methodCache.createCacheEntry(key, ClassReflectionHelperImpl.getAllMethodWrappers(key), false);
        }
    });
    private final LRUHybridCache<Class<?>, Set<Field>> fieldCache = new LRUHybridCache(200, new Computable<Class<?>, HybridCacheEntry<Set<Field>>>(){

        @Override
        public HybridCacheEntry<Set<Field>> compute(Class<?> key) {
            return ClassReflectionHelperImpl.this.fieldCache.createCacheEntry(key, ClassReflectionHelperImpl.getAllFieldWrappers(key), false);
        }
    });

    private static Set<MethodWrapper> getObjectMethods() {
        return AccessController.doPrivileged(new PrivilegedAction<Set<MethodWrapper>>(){

            @Override
            public Set<MethodWrapper> run() {
                HashSet<MethodWrapper> retVal = new HashSet<MethodWrapper>();
                for (Method method : Object.class.getDeclaredMethods()) {
                    retVal.add(new MethodWrapperImpl(method));
                }
                return retVal;
            }
        });
    }

    private static Set<Field> getObjectFields() {
        return AccessController.doPrivileged(new PrivilegedAction<Set<Field>>(){

            @Override
            public Set<Field> run() {
                HashSet<Field> retVal = new HashSet<Field>();
                for (Field field : Object.class.getDeclaredFields()) {
                    retVal.add(field);
                }
                return retVal;
            }
        });
    }

    private static Method[] secureGetDeclaredMethods(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    private static Field[] secureGetDeclaredFields(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static Set<MethodWrapper> getDeclaredMethodWrappers(Class<?> clazz) {
        Method[] declaredMethods = ClassReflectionHelperImpl.secureGetDeclaredMethods(clazz);
        HashSet<MethodWrapper> retVal = new HashSet<MethodWrapper>();
        for (Method method : declaredMethods) {
            retVal.add(new MethodWrapperImpl(method));
        }
        return retVal;
    }

    private static Set<Field> getDeclaredFieldWrappers(Class<?> clazz) {
        Field[] declaredFields = ClassReflectionHelperImpl.secureGetDeclaredFields(clazz);
        HashSet<Field> retVal = new HashSet<Field>();
        for (Field field : declaredFields) {
            retVal.add(field);
        }
        return retVal;
    }

    public static Set<Field> getAllFieldWrappers(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        if (Object.class.equals(clazz)) {
            return OBJECT_FIELDS;
        }
        if (clazz.isInterface()) {
            return Collections.emptySet();
        }
        HashSet<Field> retVal = new HashSet<Field>();
        retVal.addAll(ClassReflectionHelperImpl.getDeclaredFieldWrappers(clazz));
        retVal.addAll(ClassReflectionHelperImpl.getAllFieldWrappers(clazz.getSuperclass()));
        return retVal;
    }

    public static Set<MethodWrapper> getAllMethodWrappers(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        if (Object.class.equals(clazz)) {
            return OBJECT_METHODS;
        }
        HashSet<MethodWrapper> retVal = new HashSet<MethodWrapper>();
        if (clazz.isInterface()) {
            for (Method method : clazz.getDeclaredMethods()) {
                MethodWrapperImpl wrapper = new MethodWrapperImpl(method);
                retVal.add(wrapper);
            }
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                retVal.addAll(ClassReflectionHelperImpl.getAllMethodWrappers(genericDeclaration));
            }
        } else {
            retVal.addAll(ClassReflectionHelperImpl.getDeclaredMethodWrappers(clazz));
            retVal.addAll(ClassReflectionHelperImpl.getAllMethodWrappers(clazz.getSuperclass()));
        }
        return retVal;
    }

    private static boolean isPostConstruct(Method m) {
        if (m.isAnnotationPresent(PostConstruct.class)) {
            if (m.getParameterTypes().length != 0) {
                throw new IllegalArgumentException("The method " + Pretty.method(m) + " annotated with @PostConstruct must not have any arguments");
            }
            return true;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        return CONVENTION_POST_CONSTRUCT.equals(m.getName());
    }

    private static boolean isPreDestroy(Method m) {
        if (m.isAnnotationPresent(PreDestroy.class)) {
            if (m.getParameterTypes().length != 0) {
                throw new IllegalArgumentException("The method " + Pretty.method(m) + " annotated with @PreDestroy must not have any arguments");
            }
            return true;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        return CONVENTION_PRE_DESTROY.equals(m.getName());
    }

    private Method getPostConstructMethod(Class<?> clazz, Class<?> matchingClass) {
        if (clazz == null || Object.class.equals(clazz)) {
            return null;
        }
        if (matchingClass.isAssignableFrom(clazz)) {
            Method retVal;
            try {
                retVal = clazz.getMethod(CONVENTION_POST_CONSTRUCT, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                retVal = null;
            }
            return retVal;
        }
        for (MethodWrapper wrapper : this.getAllMethods(clazz)) {
            Method m = wrapper.getMethod();
            if (!ClassReflectionHelperImpl.isPostConstruct(m)) continue;
            return m;
        }
        return null;
    }

    private Method getPreDestroyMethod(Class<?> clazz, Class<?> matchingClass) {
        if (clazz == null || Object.class.equals(clazz)) {
            return null;
        }
        if (matchingClass.isAssignableFrom(clazz)) {
            Method retVal;
            try {
                retVal = clazz.getMethod(CONVENTION_PRE_DESTROY, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                retVal = null;
            }
            return retVal;
        }
        for (MethodWrapper wrapper : this.getAllMethods(clazz)) {
            Method m = wrapper.getMethod();
            if (!ClassReflectionHelperImpl.isPreDestroy(m)) continue;
            return m;
        }
        return null;
    }

    @Override
    public Set<MethodWrapper> getAllMethods(Class<?> clazz) {
        return (Set)this.methodCache.compute((Object)clazz).getValue();
    }

    @Override
    public Set<Field> getAllFields(Class<?> clazz) {
        return (Set)this.fieldCache.compute((Object)clazz).getValue();
    }

    @Override
    public Method findPostConstruct(Class<?> clazz, Class<?> matchingClass) throws IllegalArgumentException {
        return (Method)this.postConstructCache.compute((Object)new LifecycleKey(clazz, matchingClass)).getValue();
    }

    @Override
    public Method findPreDestroy(Class<?> clazz, Class<?> matchingClass) throws IllegalArgumentException {
        return (Method)this.preDestroyCache.compute((Object)new LifecycleKey(clazz, matchingClass)).getValue();
    }

    @Override
    public void clean(Class<?> clazz) {
        while (clazz != null && !Object.class.equals(clazz)) {
            this.postConstructCache.remove(new LifecycleKey(clazz, null));
            this.preDestroyCache.remove(new LifecycleKey(clazz, null));
            this.methodCache.remove(clazz);
            this.fieldCache.remove(clazz);
            clazz = clazz.getSuperclass();
        }
    }

    @Override
    public MethodWrapper createMethodWrapper(Method m) {
        return new MethodWrapperImpl(m);
    }

    @Override
    public void dispose() {
        this.postConstructCache.clear();
        this.preDestroyCache.clear();
        this.methodCache.clear();
        this.fieldCache.clear();
    }

    @Override
    public int size() {
        return this.postConstructCache.size() + this.preDestroyCache.size() + this.methodCache.size() + this.fieldCache.size();
    }

    public String toString() {
        return "ClassReflectionHelperImpl(" + System.identityHashCode(this) + ")";
    }

    private static final class LifecycleKey {
        private final Class<?> clazz;
        private final Class<?> matchingClass;
        private final int hash;

        private LifecycleKey(Class<?> clazz, Class<?> matchingClass) {
            this.clazz = clazz;
            this.matchingClass = matchingClass;
            this.hash = clazz.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof LifecycleKey)) {
                return false;
            }
            return this.clazz.equals(((LifecycleKey)o).clazz);
        }
    }
}

