/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.glassfish.jersey.message.internal;

import java.text.ParseException;
import java.util.Map;
import org.osiam.bundled.javax.ws.rs.core.MediaType;
import org.osiam.bundled.org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.osiam.bundled.org.glassfish.jersey.message.internal.Qualified;

public class AcceptableMediaType
extends MediaType
implements Qualified {
    private final int q;

    public AcceptableMediaType(String type, String subtype) {
        super(type, subtype);
        this.q = 1000;
    }

    public AcceptableMediaType(String type, String subtype, int quality, Map<String, String> parameters) {
        super(type, subtype, parameters);
        this.q = quality;
    }

    @Override
    public int getQuality() {
        return this.q;
    }

    public static AcceptableMediaType valueOf(HttpHeaderReader reader) throws ParseException {
        String v;
        reader.hasNext();
        String type = reader.nextToken();
        String subType = "*";
        if (reader.hasNextSeparator('/', false)) {
            reader.next(false);
            subType = reader.nextToken();
        }
        Map<String, String> parameters = null;
        int quality = 1000;
        if (reader.hasNext() && (parameters = HttpHeaderReader.readParameters(reader)) != null && (v = parameters.get("q")) != null) {
            quality = HttpHeaderReader.readQualityFactor(v);
        }
        return new AcceptableMediaType(type, subType, quality, parameters);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof AcceptableMediaType) {
            AcceptableMediaType other = (AcceptableMediaType)obj;
            return this.q == other.q;
        }
        return this.q == 1000;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return this.q == 1000 ? hash : 47 * hash + this.q;
    }
}

