/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.apache.http.protocol;

import java.io.IOException;
import org.osiam.bundled.org.apache.http.HttpException;
import org.osiam.bundled.org.apache.http.HttpRequest;
import org.osiam.bundled.org.apache.http.HttpRequestInterceptor;
import org.osiam.bundled.org.apache.http.annotation.Immutable;
import org.osiam.bundled.org.apache.http.params.HttpParams;
import org.osiam.bundled.org.apache.http.protocol.HttpContext;
import org.osiam.bundled.org.apache.http.util.Args;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

