/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.apache.http.impl.cookie;

import org.osiam.bundled.org.apache.http.annotation.Immutable;
import org.osiam.bundled.org.apache.http.cookie.Cookie;
import org.osiam.bundled.org.apache.http.cookie.CookieOrigin;
import org.osiam.bundled.org.apache.http.cookie.CookieRestrictionViolationException;
import org.osiam.bundled.org.apache.http.cookie.MalformedCookieException;
import org.osiam.bundled.org.apache.http.cookie.SetCookie;
import org.osiam.bundled.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.osiam.bundled.org.apache.http.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }
}

