/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.glassfish.jersey.model.internal;

import org.osiam.bundled.javax.annotation.Priority;

public class RankedProvider<T> {
    private final T provider;
    private final int rank;

    public RankedProvider(T provider) {
        this.provider = provider;
        this.rank = this.computeRank(provider, -1);
    }

    public RankedProvider(T provider, int rank) {
        this.provider = provider;
        this.rank = this.computeRank(provider, rank);
    }

    private int computeRank(T provider, int rank) {
        if (rank > 0) {
            return rank;
        }
        if (provider.getClass().isAnnotationPresent(Priority.class)) {
            return provider.getClass().getAnnotation(Priority.class).value();
        }
        return 5000;
    }

    public T getProvider() {
        return this.provider;
    }

    public int getRank() {
        return this.rank;
    }

    public String toString() {
        return this.provider.getClass().getName();
    }
}

