/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import java.net.URI;
import java.util.List;
import org.osiam.client.AuthService;
import org.osiam.client.OsiamGroupService;
import org.osiam.client.OsiamUserService;
import org.osiam.client.exception.InvalidAttributeException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.oauth.Scope;
import org.osiam.client.query.Query;
import org.osiam.client.query.QueryBuilder;
import org.osiam.client.user.BasicUser;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.UpdateGroup;
import org.osiam.resources.scim.UpdateUser;
import org.osiam.resources.scim.User;

public class OsiamConnector {
    private String clientId;
    private String clientSecret;
    private String genEndpoint;
    private String authServiceEndpoint;
    private String resourceServiceEndpoint;
    private String clientRedirectUri;
    private AuthService authService;
    private OsiamUserService userService;
    private OsiamGroupService groupService;

    private OsiamConnector(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.authServiceEndpoint = builder.authServiceEndpoint;
        this.resourceServiceEndpoint = builder.resourceServiceEndpoint;
        this.genEndpoint = builder.genEndpoint;
        this.clientRedirectUri = builder.clientRedirectUri;
    }

    private AuthService authService() {
        if (this.authService == null) {
            AuthService.Builder builder = new AuthService.Builder(this.getAuthServiceEndPoint());
            if (this.clientId != null) {
                builder = builder.setClientId(this.clientId);
            }
            if (this.clientSecret != null) {
                builder = builder.setClientSecret(this.clientSecret);
            }
            if (this.clientRedirectUri != null) {
                builder = builder.setClientRedirectUri(this.clientRedirectUri);
            }
            this.authService = builder.build();
        }
        return this.authService;
    }

    private String getAuthServiceEndPoint() {
        if (this.authServiceEndpoint != null && !this.authServiceEndpoint.isEmpty()) {
            return this.authServiceEndpoint;
        }
        if (this.genEndpoint != null && !this.genEndpoint.isEmpty()) {
            StringBuilder endpoint = new StringBuilder(this.genEndpoint);
            if (!this.genEndpoint.endsWith("/")) {
                endpoint.append("/");
            }
            endpoint.append("osiam-auth-server/");
            return endpoint.toString();
        }
        throw new InvalidAttributeException("No endpoint to the OSIAM server has been set");
    }

    private String getResourceServiceEndPoint() {
        if (this.resourceServiceEndpoint != null && !this.resourceServiceEndpoint.isEmpty()) {
            return this.resourceServiceEndpoint;
        }
        if (this.genEndpoint != null && !this.genEndpoint.isEmpty()) {
            StringBuilder endpoint = new StringBuilder(this.genEndpoint);
            if (!this.genEndpoint.endsWith("/")) {
                endpoint.append("/");
            }
            endpoint.append("osiam-resource-server");
            return endpoint.toString();
        }
        throw new InvalidAttributeException("No endpoint to the OSIAM server has been set");
    }

    private OsiamUserService userService() {
        if (this.userService == null) {
            this.userService = new OsiamUserService.Builder(this.getResourceServiceEndPoint()).build();
        }
        return this.userService;
    }

    private OsiamGroupService groupService() {
        if (this.groupService == null) {
            this.groupService = new OsiamGroupService.Builder(this.getResourceServiceEndPoint()).build();
        }
        return this.groupService;
    }

    public User getUser(String id, AccessToken accessToken) {
        return this.userService().getUser(id, accessToken);
    }

    public List<User> getAllUsers(AccessToken accessToken) {
        return this.userService().getAllUsers(accessToken);
    }

    public SCIMSearchResult<User> searchUsers(Query query, AccessToken accessToken) {
        return this.userService().searchResources(query, accessToken);
    }

    public User getCurrentUser(AccessToken accessToken) {
        return this.userService().getCurrentUser(accessToken);
    }

    public BasicUser getCurrentUserBasic(AccessToken accessToken) {
        return this.userService().getCurrentUserBasic(accessToken);
    }

    public Group getGroup(String id, AccessToken accessToken) {
        return this.groupService().getGroup(id, accessToken);
    }

    public List<Group> getAllGroups(AccessToken accessToken) {
        return this.groupService().getAllGroups(accessToken);
    }

    public SCIMSearchResult<Group> searchGroups(Query query, AccessToken accessToken) {
        return this.groupService().searchGroups(query, accessToken);
    }

    public AccessToken refreshAccessToken(AccessToken accessToken, Scope ... scopes) {
        return this.authService().refreshAccessToken(accessToken, scopes);
    }

    public URI getAuthorizationUri(Scope ... scopes) {
        return this.authService().getAuthorizationUri(scopes);
    }

    public AccessToken retrieveAccessToken(Scope ... scopes) {
        return this.authService().retrieveAccessToken(scopes);
    }

    public AccessToken retrieveAccessToken(String userName, String password, Scope ... scopes) {
        return this.authService().retrieveAccessToken(userName, password, scopes);
    }

    public AccessToken retrieveAccessToken(String authCode) {
        return this.authService().retrieveAccessToken(authCode);
    }

    public User createUser(User user, AccessToken accessToken) {
        return this.userService().createUser(user, accessToken);
    }

    public Group createGroup(Group group, AccessToken accessToken) {
        return this.groupService().createGroup(group, accessToken);
    }

    public void deleteGroup(String id, AccessToken accessToken) {
        this.groupService().deleteGroup(id, accessToken);
    }

    public void deleteUser(String id, AccessToken accessToken) {
        this.userService().deleteUser(id, accessToken);
    }

    public User updateUser(String id, UpdateUser updateUser, AccessToken accessToken) {
        return this.userService().updateUser(id, updateUser, accessToken);
    }

    public User replaceUser(String id, User user, AccessToken accessToken) {
        return this.userService().replaceUser(id, user, accessToken);
    }

    public Group updateGroup(String id, UpdateGroup updateGroup, AccessToken accessToken) {
        return this.groupService().updateGroup(id, updateGroup, accessToken);
    }

    public Group replaceGroup(String id, Group group, AccessToken accessToken) {
        return this.groupService().updateGroup(id, group, accessToken);
    }

    public AccessToken validateAccessToken(AccessToken tokenToValidate) {
        return this.authService().validateAccessToken(tokenToValidate);
    }

    public void revokeAccessToken(AccessToken tokenToRevoke) {
        this.authService().revokeAccessToken(tokenToRevoke);
    }

    public void revokeAllAccessTokens(String id, AccessToken accessToken) {
        this.authService().revokeAllAccessTokens(id, accessToken);
    }

    public QueryBuilder createQueryBuilder() {
        return new QueryBuilder();
    }

    public QueryBuilder createQueryBuilder(Query original) {
        return new QueryBuilder(original);
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private String genEndpoint;
        private String authServiceEndpoint;
        private String resourceServiceEndpoint;
        private String clientRedirectUri;

        public Builder setEndpoint(String endpoint) {
            this.genEndpoint = endpoint;
            return this;
        }

        public Builder setAuthServerEndpoint(String endpoint) {
            this.authServiceEndpoint = endpoint;
            return this;
        }

        public Builder setResourceServerEndpoint(String endpoint) {
            this.resourceServiceEndpoint = endpoint;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setClientRedirectUri(String clientRedirectUri) {
            this.clientRedirectUri = clientRedirectUri;
            return this;
        }

        public OsiamConnector build() {
            return new OsiamConnector(this);
        }
    }
}

