/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.jvnet.hk2.internal;

import org.osiam.bundled.javax.inject.Inject;
import org.osiam.bundled.javax.inject.Named;
import org.osiam.bundled.org.glassfish.hk2.api.ActiveDescriptor;
import org.osiam.bundled.org.glassfish.hk2.api.Injectee;
import org.osiam.bundled.org.glassfish.hk2.api.InjectionResolver;
import org.osiam.bundled.org.glassfish.hk2.api.MultiException;
import org.osiam.bundled.org.glassfish.hk2.api.ServiceHandle;
import org.osiam.bundled.org.glassfish.hk2.api.UnsatisfiedDependencyException;
import org.osiam.bundled.org.jvnet.hk2.internal.ServiceLocatorImpl;

@Named(value="SystemInjectResolver")
public class ThreeThirtyResolver
implements InjectionResolver<Inject> {
    private final ServiceLocatorImpl locator;

    ThreeThirtyResolver(ServiceLocatorImpl locator) {
        this.locator = locator;
    }

    @Override
    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        ActiveDescriptor<?> ad = this.locator.getInjecteeDescriptor(injectee);
        if (ad == null) {
            if (injectee.isOptional()) {
                return null;
            }
            throw new MultiException(new UnsatisfiedDependencyException(injectee));
        }
        return this.locator.getService(ad, root, injectee);
    }

    @Override
    public boolean isConstructorParameterIndicator() {
        return false;
    }

    @Override
    public boolean isMethodParameterIndicator() {
        return false;
    }
}

