/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import com.google.common.base.Strings;
import java.util.List;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import org.osiam.client.AbstractOsiamService;
import org.osiam.client.exception.ConnectionInitializationException;
import org.osiam.client.exception.InvalidAttributeException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.query.Query;
import org.osiam.client.user.BasicUser;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.UpdateUser;
import org.osiam.resources.scim.User;

class OsiamUserService
extends AbstractOsiamService<User> {
    private OsiamUserService(Builder builder) {
        super(builder);
    }

    public User getUser(String id, AccessToken accessToken) {
        return (User)this.getResource(id, accessToken);
    }

    public BasicUser getCurrentUserBasic(AccessToken accessToken) {
        String content;
        Response.StatusType status;
        OsiamUserService.checkAccessTokenIsNotNull(accessToken);
        try {
            Response response = this.targetEndpoint.path("me").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken.getToken())).get();
            status = response.getStatusInfo();
            content = (String)response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException("Cannot connect to server", e);
        }
        this.checkAndHandleResponse(content, status, accessToken, "get me", null);
        return this.mapToType(content, BasicUser.class);
    }

    public User getCurrentUser(AccessToken accessToken) {
        BasicUser basicUser = this.getCurrentUserBasic(accessToken);
        return (User)this.getResource(basicUser.getId(), accessToken);
    }

    public List<User> getAllUsers(AccessToken accessToken) {
        return super.getAllResources(accessToken);
    }

    public SCIMSearchResult<User> searchUsers(Query query, AccessToken accessToken) {
        return this.searchResources(query, accessToken);
    }

    public void deleteUser(String id, AccessToken accessToken) {
        this.deleteResource(id, accessToken);
    }

    public User createUser(User user, AccessToken accessToken) {
        return this.createResource(user, accessToken);
    }

    public User updateUser(String id, UpdateUser updateUser, AccessToken accessToken) {
        if (updateUser == null) {
            throw new IllegalArgumentException("The given updateUser can't be null.");
        }
        return this.updateResource(id, updateUser.getScimConformUpdateUser(), accessToken);
    }

    public User replaceUser(String id, User user, AccessToken accessToken) {
        if (user == null) {
            throw new InvalidAttributeException("The given User can't be null.");
        }
        if (Strings.isNullOrEmpty((String)id)) {
            throw new InvalidAttributeException("The given User ID can't be null or empty.");
        }
        return this.replaceResource(id, user, accessToken);
    }

    public static class Builder
    extends AbstractOsiamService.Builder<User> {
        public Builder(String endpoint) {
            super(endpoint);
        }

        public OsiamUserService build() {
            return new OsiamUserService(this);
        }
    }
}

