/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.osiam.client.exception.ConflictException;
import org.osiam.client.exception.ConnectionInitializationException;
import org.osiam.client.exception.ForbiddenException;
import org.osiam.client.exception.InvalidAttributeException;
import org.osiam.client.exception.OsiamErrorMessage;
import org.osiam.client.exception.UnauthorizedException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.oauth.GrantType;
import org.osiam.client.oauth.Scope;

public final class AuthService {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private HttpPost post;
    private final String endpoint;
    private Header[] headers;
    private String clientId;
    private String clientSecret;
    private String clientRedirectUri;
    private String scopes;
    private String password;
    private String userName;
    private GrantType grantType;
    private HttpEntity body;

    private AuthService(Builder builder) {
        this.endpoint = builder.endpoint;
        this.scopes = builder.scopes;
        this.grantType = builder.grantType;
        this.userName = builder.userName;
        this.password = builder.password;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.clientRedirectUri = builder.clientRedirectUri;
    }

    private HttpResponse performRequest() {
        HttpResponse response;
        if (this.post == null) {
            this.buildHead();
            this.buildBody();
            this.post = new HttpPost(this.getFinalEndpoint());
            this.post.setHeaders(this.headers);
            this.post.setEntity(this.body);
        }
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        try {
            response = defaultHttpClient.execute((HttpUriRequest)this.post);
        }
        catch (IOException e) {
            throw new ConnectionInitializationException("Unable to perform Request ", e);
        }
        return response;
    }

    private void buildHead() {
        String authHeaderValue = "Basic " + this.encodeClientCredentials(this.clientId, this.clientSecret);
        BasicHeader authHeader = new BasicHeader("Authorization", authHeaderValue);
        this.headers = new Header[]{authHeader};
    }

    private String encodeClientCredentials(String clientId, String clientSecret) {
        String clientCredentials = clientId + ":" + clientSecret;
        clientCredentials = new String(Base64.encodeBase64((byte[])clientCredentials.getBytes(CHARSET)), CHARSET);
        return clientCredentials;
    }

    private void buildBody() {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("scope", this.scopes));
        nameValuePairs.add(new BasicNameValuePair("grant_type", this.grantType.getUrlParam()));
        if (this.userName != null) {
            nameValuePairs.add(new BasicNameValuePair("username", this.userName));
        }
        if (this.password != null) {
            nameValuePairs.add(new BasicNameValuePair("password", this.password));
        }
        try {
            this.body = new UrlEncodedFormEntity(nameValuePairs);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConnectionInitializationException("Unable to Build Request in this encoding.", e);
        }
    }

    public AccessToken retrieveAccessToken() {
        if (this.grantType == GrantType.AUTHORIZATION_CODE) {
            throw new IllegalAccessError("For the grant type " + (Object)((Object)GrantType.AUTHORIZATION_CODE) + " you need to retrieve a authentication code first.");
        }
        HttpResponse response = this.performRequest();
        int status = response.getStatusLine().getStatusCode();
        if (status != 200) {
            switch (status) {
                case 400: {
                    String defaultMessage = "Unable to create Connection. Please make sure that you have the correct grants.";
                    String errorMessage = this.getErrorMessage(response, defaultMessage);
                    throw new ConnectionInitializationException(errorMessage);
                }
                case 401: {
                    String defaultMessage = "You are not authorized to directly retrieve a access token.";
                    String errorMessage = this.getErrorMessage(response, defaultMessage);
                    throw new UnauthorizedException(errorMessage);
                }
                case 404: {
                    String defaultMessage = "Unable to find the given OSIAM service (" + this.getFinalEndpoint() + ")";
                    String errorMessage = this.getErrorMessage(response, defaultMessage);
                    throw new ConnectionInitializationException(errorMessage);
                }
            }
            String defaultMessage = String.format("Unable to setup connection (HTTP Status Code: %d)", status);
            String errorMessage = this.getErrorMessage(response, defaultMessage);
            throw new ConnectionInitializationException(errorMessage);
        }
        return this.getAccessToken(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getErrorMessage(HttpResponse httpResponse, String defaultErrorMessage) {
        String errorMessage;
        InputStream content = null;
        try {
            content = httpResponse.getEntity().getContent();
            ObjectMapper mapper = new ObjectMapper();
            OsiamErrorMessage error = (OsiamErrorMessage)mapper.readValue(content, OsiamErrorMessage.class);
            errorMessage = error.getDescription();
        }
        catch (Exception e) {
            errorMessage = defaultErrorMessage;
        }
        finally {
            try {
                if (content != null) {
                    content.close();
                }
            }
            catch (IOException notNeeded) {}
        }
        if (errorMessage == null) {
            errorMessage = defaultErrorMessage;
        }
        return errorMessage;
    }

    public URI getRedirectLoginUri() {
        URI returnUri;
        if (this.grantType != GrantType.AUTHORIZATION_CODE) {
            throw new IllegalAccessError("You need to use the GrantType " + (Object)((Object)GrantType.AUTHORIZATION_CODE) + " to be able to use this method.");
        }
        try {
            returnUri = new URIBuilder().setPath(this.getFinalEndpoint()).addParameter("client_id", this.clientId).addParameter("response_type", "code").addParameter("redirect_uri", this.clientRedirectUri).addParameter("scope", this.scopes).build();
        }
        catch (URISyntaxException e) {
            throw new ConnectionInitializationException("Unable to create redirect URI", e);
        }
        return returnUri;
    }

    public AccessToken retrieveAccessToken(HttpResponse authCodeResponse) {
        HeaderElement[] elements;
        String authCode = null;
        Header header = authCodeResponse.getLastHeader("Location");
        for (HeaderElement actHeaderElement : elements = header.getElements()) {
            if (actHeaderElement.getName().contains("code")) {
                authCode = actHeaderElement.getValue();
                break;
            }
            if (!actHeaderElement.getName().contains("error")) continue;
            throw new ForbiddenException("The user had denied the acces to his data.");
        }
        if (authCode == null) {
            throw new InvalidAttributeException("Could not find any auth code or error message in the given Response");
        }
        return this.retrieveAccessToken(authCode);
    }

    public AccessToken retrieveAccessToken(String authCode) {
        HttpResponse response;
        if (authCode == null) {
            throw new IllegalArgumentException("The given authentication code can't be null.");
        }
        HttpPost realWebResource = this.getWebRessourceToEchangeAuthCode(authCode);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        int httpStatus = 0;
        try {
            response = httpclient.execute((HttpUriRequest)realWebResource);
            httpStatus = response.getStatusLine().getStatusCode();
        }
        catch (IOException e) {
            throw new ConnectionInitializationException("Unable to setup connection", e);
        }
        if (httpStatus != 200) {
            switch (httpStatus) {
                case 400: {
                    String errorMessage = this.getErrorMessage(response, "Could not exchange yout authentication code against a access token.");
                    throw new ConflictException(errorMessage);
                }
            }
            String errorMessage = this.getErrorMessage(response, String.format("Unable to setup connection (HTTP Status Code: %d)", httpStatus));
            throw new ConnectionInitializationException(errorMessage);
        }
        return this.getAccessToken(response);
    }

    private AccessToken getAccessToken(HttpResponse response) {
        AccessToken accessToken;
        try {
            InputStream content = response.getEntity().getContent();
            ObjectMapper mapper = new ObjectMapper();
            accessToken = (AccessToken)mapper.readValue(content, AccessToken.class);
        }
        catch (IOException e) {
            throw new ConnectionInitializationException("Unable to retrieve access token: IOException", e);
        }
        return accessToken;
    }

    private String getFinalEndpoint() {
        String finalEndpoint = this.endpoint;
        finalEndpoint = this.grantType.equals((Object)GrantType.AUTHORIZATION_CODE) ? finalEndpoint + "/oauth/authorize" : finalEndpoint + "/oauth/token";
        return finalEndpoint;
    }

    private HttpPost getWebRessourceToEchangeAuthCode(String authCode) {
        HttpPost realWebResource = new HttpPost(this.endpoint + "/oauth/token");
        String authHeaderValue = "Basic " + this.encodeClientCredentials(this.clientId, this.clientSecret);
        realWebResource.addHeader("Authorization", authHeaderValue);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("code", authCode));
        nameValuePairs.add(new BasicNameValuePair("grant_type", "authorization_code"));
        nameValuePairs.add(new BasicNameValuePair("redirect_uri", this.clientRedirectUri));
        try {
            realWebResource.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ConnectionInitializationException("Unable to Build Request in this encoding.", e);
        }
        return realWebResource;
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private GrantType grantType;
        private String scopes;
        private String endpoint;
        private String password;
        private String userName;
        private String clientRedirectUri;

        public Builder(String endpoint) {
            this.endpoint = endpoint;
        }

        public Builder setScope(Scope scope, Scope ... scopes) {
            HashSet<Scope> scopeSet = new HashSet<Scope>();
            scopeSet.add(scope);
            for (Scope actScope : scopes) {
                scopeSet.add(actScope);
            }
            if (scopeSet.contains((Object)Scope.ALL)) {
                this.scopes = Scope.ALL.toString();
            } else {
                StringBuilder scopeBuilder = new StringBuilder();
                for (Scope actScope : scopeSet) {
                    scopeBuilder.append(" ").append(actScope.toString());
                }
                this.scopes = scopeBuilder.toString().trim();
            }
            return this;
        }

        public Builder setScope(String scope) {
            this.scopes = scope;
            return this;
        }

        public Builder setGrantType(GrantType grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientRedirectUri(String clientRedirectUri) {
            this.clientRedirectUri = clientRedirectUri;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setUsername(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public AuthService build() {
            this.ensureAllNeededParameterAreCorrect();
            return new AuthService(this);
        }

        private void ensureAllNeededParameterAreCorrect() {
            if (this.clientId == null || this.clientSecret == null) {
                throw new IllegalArgumentException("The provided client credentials are incomplete.");
            }
            if (this.scopes == null) {
                throw new IllegalArgumentException("At least one scope needs to be set.");
            }
            if (this.grantType == null) {
                throw new IllegalArgumentException("The grant type is not set.");
            }
            if (this.grantType.equals((Object)GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS) && this.userName == null && this.password == null) {
                throw new IllegalArgumentException("The grant type 'password' requires username and password");
            }
            if ((this.grantType.equals((Object)GrantType.CLIENT_CREDENTIALS) || this.grantType.equals((Object)GrantType.AUTHORIZATION_CODE)) && (this.userName != null || this.password != null)) {
                throw new IllegalArgumentException("For the grant type '" + (Object)((Object)this.grantType) + "' setting of password and username are not allowed.");
            }
            if (this.grantType.equals((Object)GrantType.AUTHORIZATION_CODE) && this.clientRedirectUri == null) {
                throw new IllegalArgumentException("For the grant type '" + (Object)((Object)this.grantType) + "' the redirect Uri is needed.");
            }
        }
    }
}

