/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.connector;

import java.net.URI;
import java.util.List;
import org.apache.http.HttpResponse;
import org.osiam.client.OsiamGroupService;
import org.osiam.client.OsiamUserService;
import org.osiam.client.exception.InvalidAttributeException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.oauth.AuthService;
import org.osiam.client.oauth.GrantType;
import org.osiam.client.oauth.Scope;
import org.osiam.client.query.Query;
import org.osiam.client.update.UpdateGroup;
import org.osiam.client.update.UpdateUser;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.User;

public final class OsiamConnector {
    private String clientId;
    private String clientSecret;
    private GrantType grantType;
    private String username;
    private String password;
    private String genEndpoint;
    private String authServiceEndpoint;
    private String resourceServiceEndpoint;
    private Scope scope;
    private Scope[] scopes;
    private String stringScope;
    private String clientRedirectUri;
    private AuthService authService;
    private OsiamUserService userService;
    private OsiamGroupService groupService;

    private OsiamConnector(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.grantType = builder.grantType;
        this.username = builder.username;
        this.password = builder.password;
        this.authServiceEndpoint = builder.authServiceEndpoint;
        this.resourceServiceEndpoint = builder.resourceServiceEndpoint;
        this.genEndpoint = builder.genEndpoint;
        this.scope = builder.scope;
        this.scopes = builder.scopes;
        this.stringScope = builder.stringScope;
        this.clientRedirectUri = builder.clientRedirectUri;
    }

    private AuthService authService() {
        if (this.authService == null) {
            AuthService.Builder builder = new AuthService.Builder(this.getAuthServiceEndPoint());
            if (this.clientId != null) {
                builder = builder.setClientId(this.clientId);
            }
            if (this.clientSecret != null) {
                builder = builder.setClientSecret(this.clientSecret);
            }
            if (this.grantType != null) {
                builder = builder.setGrantType(this.grantType);
            }
            if (this.password != null) {
                builder = builder.setPassword(this.password);
            }
            if (this.username != null) {
                builder = builder.setUsername(this.username);
            }
            if (this.scope != null && this.scopes != null) {
                builder = builder.setScope(this.scope, this.scopes);
            } else if (this.scope != null) {
                builder = builder.setScope(this.scope, new Scope[0]);
            }
            if (this.stringScope != null) {
                builder = builder.setScope(this.stringScope);
            }
            if (this.clientRedirectUri != null) {
                builder = builder.setClientRedirectUri(this.clientRedirectUri);
            }
            this.authService = builder.build();
        }
        return this.authService;
    }

    private String getAuthServiceEndPoint() {
        if (this.authServiceEndpoint != null && !this.authServiceEndpoint.isEmpty()) {
            return this.authServiceEndpoint;
        }
        if (this.genEndpoint != null && !this.genEndpoint.isEmpty()) {
            StringBuilder endpoint = new StringBuilder(this.genEndpoint);
            if (!this.genEndpoint.endsWith("/")) {
                endpoint.append("/");
            }
            endpoint.append("osiam-auth-server/");
            return endpoint.toString();
        }
        throw new InvalidAttributeException("No endpoint to the OSIAM server has been set");
    }

    private String getResourceServiceEndPoint() {
        if (this.resourceServiceEndpoint != null && !this.resourceServiceEndpoint.isEmpty()) {
            return this.resourceServiceEndpoint;
        }
        if (this.genEndpoint != null && !this.genEndpoint.isEmpty()) {
            StringBuilder endpoint = new StringBuilder(this.genEndpoint);
            if (!this.genEndpoint.endsWith("/")) {
                endpoint.append("/");
            }
            endpoint.append("osiam-resource-server/");
            return endpoint.toString();
        }
        throw new InvalidAttributeException("No endpoint to the OSIAM server has been set");
    }

    private OsiamUserService userService() {
        if (this.userService == null) {
            this.userService = new OsiamUserService.Builder(this.getResourceServiceEndPoint()).build();
        }
        return this.userService;
    }

    private OsiamGroupService groupService() {
        if (this.groupService == null) {
            this.groupService = new OsiamGroupService.Builder(this.getResourceServiceEndPoint()).build();
        }
        return this.groupService;
    }

    public User getUser(String id, AccessToken accessToken) {
        return this.userService().getUser(id, accessToken);
    }

    public List<User> getAllUsers(AccessToken accessToken) {
        return this.userService().getAllUsers(accessToken);
    }

    public SCIMSearchResult<User> searchUsers(String queryString, AccessToken accessToken) {
        return this.userService().searchUsers(queryString, accessToken);
    }

    public SCIMSearchResult<User> searchUsers(Query query, AccessToken accessToken) {
        return this.userService().searchUsers(query, accessToken);
    }

    public User getMe(AccessToken accessToken) {
        return this.userService().getMe(accessToken);
    }

    public User getMeBasic(AccessToken accessToken) {
        return this.userService().getMeBasic(accessToken);
    }

    public Group getGroup(String id, AccessToken accessToken) {
        return this.groupService().getGroup(id, accessToken);
    }

    public List<Group> getAllGroups(AccessToken accessToken) {
        return this.groupService().getAllGroups(accessToken);
    }

    public SCIMSearchResult<Group> searchGroups(String queryString, AccessToken accessToken) {
        return this.groupService().searchGroups(queryString, accessToken);
    }

    public SCIMSearchResult<Group> searchGroups(Query query, AccessToken accessToken) {
        return this.groupService().searchGroups(query, accessToken);
    }

    public AccessToken retrieveAccessToken() {
        return this.authService().retrieveAccessToken();
    }

    public URI getRedirectLoginUri() {
        return this.authService().getRedirectLoginUri();
    }

    public AccessToken retrieveAccessToken(HttpResponse authCodeResponse) {
        return this.authService().retrieveAccessToken(authCodeResponse);
    }

    public AccessToken retrieveAccessToken(String authCode) {
        return this.authService().retrieveAccessToken(authCode);
    }

    public User createUser(User user, AccessToken accessToken) {
        return this.userService().createUser(user, accessToken);
    }

    public Group createGroup(Group group, AccessToken accessToken) {
        return this.groupService().createGroup(group, accessToken);
    }

    public void deleteGroup(String id, AccessToken accessToken) {
        this.groupService().deleteGroup(id, accessToken);
    }

    public void deleteUser(String id, AccessToken accessToken) {
        this.userService().deleteUser(id, accessToken);
    }

    public User updateUser(String id, UpdateUser updateUser, AccessToken accessToken) {
        return this.userService().updateUser(id, updateUser, accessToken);
    }

    public User updateUser(String uuid, User user, AccessToken accessToken) {
        return this.userService().updateUser(uuid, user, accessToken);
    }

    public User replaceUser(User user, AccessToken accessToken) {
        return this.userService().replaceUser(user, accessToken);
    }

    public Group updateGroup(String id, UpdateGroup updateGroup, AccessToken accessToken) {
        return this.groupService().updateGroup(id, updateGroup, accessToken);
    }

    public Group updateGroup(String id, Group group, AccessToken accessToken) {
        return this.groupService().updateGroup(id, group, accessToken);
    }

    public Group replaceGroup(String id, Group group, AccessToken accessToken) {
        return this.groupService().updateGroup(id, group, accessToken);
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private GrantType grantType;
        private String username;
        private String password;
        private String genEndpoint;
        private String authServiceEndpoint;
        private String resourceServiceEndpoint;
        private Scope scope;
        private Scope[] scopes;
        private String stringScope;
        private String clientRedirectUri;

        public Builder setEndpoint(String endpoint) {
            this.genEndpoint = endpoint;
            return this;
        }

        public Builder setAuthServiceEndpoint(String endpoint) {
            this.authServiceEndpoint = endpoint;
            return this;
        }

        public Builder setResourceEndpoint(String endpoint) {
            this.resourceServiceEndpoint = endpoint;
            return this;
        }

        public Builder setScope(Scope scope, Scope ... scopes) {
            this.scope = scope;
            this.scopes = scopes;
            return this;
        }

        public Builder setScope(String scope) {
            this.stringScope = scope;
            return this;
        }

        public Builder setGrantType(GrantType grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setUserName(String userName) {
            this.username = userName;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setClientRedirectUri(String clientRedirectUri) {
            this.clientRedirectUri = clientRedirectUri;
            return this;
        }

        public OsiamConnector build() {
            return new OsiamConnector(this);
        }
    }
}

