/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.osiam.client.exception.ConflictException;
import org.osiam.client.exception.ConnectionInitializationException;
import org.osiam.client.exception.ForbiddenException;
import org.osiam.client.exception.NoResultException;
import org.osiam.client.exception.NotFoundException;
import org.osiam.client.exception.OsiamErrorMessage;
import org.osiam.client.exception.UnauthorizedException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.query.Query;
import org.osiam.resources.helper.UserDeserializer;
import org.osiam.resources.scim.CoreResource;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.User;

abstract class AbstractOsiamService<T extends CoreResource> {
    private HttpGet webResource;
    private Class<T> type;
    private String typeName;
    private ObjectMapper mapper = new ObjectMapper();
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer ";
    private DefaultHttpClient httpclient;
    private ContentType contentType;
    private String endpoint;

    protected AbstractOsiamService(Builder builder) {
        SimpleModule userDeserializerModule = new SimpleModule("userDeserializerModule", new Version(1, 0, 0, null)).addDeserializer(User.class, (JsonDeserializer)new UserDeserializer(User.class));
        this.mapper.registerModule((Module)userDeserializerModule);
        this.contentType = ContentType.create((String)"application/json");
        this.webResource = builder.getWebResource();
        this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.typeName = this.type.getSimpleName();
        this.endpoint = builder.endpoint;
    }

    public URI getUri() {
        return this.webResource.getURI();
    }

    protected String getEndpoint() {
        return this.endpoint;
    }

    protected T getResource(String id, AccessToken accessToken) {
        T t;
        this.ensureReferenceIsNotNull(id, "The given id can't be null.");
        this.ensureAccessTokenIsNotNull(accessToken);
        InputStream content = null;
        try {
            T resource;
            HttpGet realWebResource = this.createRealWebResource(accessToken);
            realWebResource.setURI(new URI(this.webResource.getURI() + "/" + id));
            this.httpclient = new DefaultHttpClient();
            HttpResponse response = this.httpclient.execute((HttpUriRequest)realWebResource);
            int httpStatus = response.getStatusLine().getStatusCode();
            if (httpStatus != 200) {
                switch (httpStatus) {
                    case 401: {
                        String errorMessage = this.getErrorMessageUnauthorized(response);
                        throw new UnauthorizedException(errorMessage);
                    }
                    case 404: {
                        String errorMessage = this.getErrorMessage(response, "No " + this.typeName + " with given id " + id);
                        throw new NoResultException(errorMessage);
                    }
                    case 403: {
                        String errorMessage = this.getErrorMessageForbidden(accessToken, "get");
                        throw new ForbiddenException(errorMessage);
                    }
                }
                String errorMessage = this.getErrorMessageDefault(response, httpStatus);
                throw new ConnectionInitializationException(errorMessage);
            }
            content = response.getEntity().getContent();
            t = resource = this.mapSingleResourceResponse(content);
        }
        catch (IOException | URISyntaxException e) {
            throw this.createSetupConnectionException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (Exception ignore) {}
        }
        return t;
    }

    protected List<T> getAllResources(AccessToken accessToken) {
        return this.searchResources("count=2147483647", accessToken).getResources();
    }

    protected SCIMSearchResult<T> searchResources(String queryString, AccessToken accessToken) {
        this.ensureAccessTokenIsNotNull(accessToken);
        try {
            SCIMSearchResult result;
            HttpGet realWebResource = this.createRealWebResource(accessToken);
            URI uri = new URI(this.webResource.getURI() + (queryString.isEmpty() ? "" : "?" + queryString));
            realWebResource.setURI(uri);
            this.httpclient = new DefaultHttpClient();
            HttpResponse response = this.httpclient.execute((HttpUriRequest)realWebResource);
            int httpStatus = response.getStatusLine().getStatusCode();
            if (httpStatus != 200) {
                switch (httpStatus) {
                    case 401: {
                        String errorMessage = this.getErrorMessageUnauthorized(response);
                        throw new UnauthorizedException(errorMessage);
                    }
                    case 403: {
                        String errorMessage = this.getErrorMessageForbidden(accessToken, "get");
                        throw new ForbiddenException(errorMessage);
                    }
                }
                String errorMessage = this.getErrorMessageDefault(response, httpStatus);
                throw new ConnectionInitializationException(errorMessage);
            }
            InputStream queryResult = response.getEntity().getContent();
            JavaType queryResultType = TypeFactory.defaultInstance().constructParametricType(SCIMSearchResult.class, new Class[]{this.type});
            try {
                result = (SCIMSearchResult)this.mapper.readValue(queryResult, queryResultType);
            }
            catch (IOException e) {
                throw new ConnectionInitializationException("Unable to deserialize query result", e);
            }
            return result;
        }
        catch (IOException | URISyntaxException e) {
            throw this.createSetupConnectionException(e);
        }
    }

    protected SCIMSearchResult<T> searchResources(Query query, AccessToken accessToken) {
        if (query == null) {
            throw new IllegalArgumentException("The given queryBuilder can't be null.");
        }
        return this.searchResources(query.toString(), accessToken);
    }

    protected T mapSingleResourceResponse(InputStream content) throws IOException {
        return (T)((CoreResource)this.mapper.readValue(content, this.type));
    }

    protected String getErrorMessageForbidden(AccessToken accessToken, String process) {
        return "Insufficient scope (" + accessToken.getScope() + ") to " + process + " this " + this.typeName + ".";
    }

    protected String getErrorMessageUnauthorized(HttpResponse httpResponse) throws IOException {
        return this.getErrorMessage(httpResponse, "You are not authorized to access OSIAM. Please make sure your access token is valid");
    }

    protected String getErrorMessageDefault(HttpResponse httpResponse, int httpStatus) throws IOException {
        return this.getErrorMessage(httpResponse, String.format("Unable to setup connection (HTTP Status Code: %d)", httpStatus));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getErrorMessage(HttpResponse httpResponse, String defaultErrorMessage) throws IOException {
        String errorMessage;
        try (InputStream content = httpResponse.getEntity().getContent();){
            OsiamErrorMessage error = (OsiamErrorMessage)this.mapper.readValue(content, OsiamErrorMessage.class);
            errorMessage = error.getDescription();
        }
        if (errorMessage == null) {
            errorMessage = defaultErrorMessage;
        }
        return errorMessage;
    }

    protected HttpGet createRealWebResource(AccessToken accessToken) {
        try {
            HttpGet realWebResource = (HttpGet)this.webResource.clone();
            realWebResource.addHeader(AUTHORIZATION, BEARER + accessToken.getToken());
            return realWebResource;
        }
        catch (CloneNotSupportedException ignore) {
            throw new RuntimeException("This should not happen!");
        }
    }

    protected void deleteResource(String id, AccessToken accessToken) {
        this.ensureReferenceIsNotNull(id, "The given id can't be null.");
        this.ensureAccessTokenIsNotNull(accessToken);
        try {
            URI uri = new URI(this.webResource.getURI() + "/" + id);
            HttpDelete realWebResource = new HttpDelete(uri);
            realWebResource.addHeader(AUTHORIZATION, BEARER + accessToken.getToken());
            this.httpclient = new DefaultHttpClient();
            HttpResponse response = this.httpclient.execute((HttpUriRequest)realWebResource);
            int httpStatus = response.getStatusLine().getStatusCode();
            if (httpStatus != 200) {
                switch (httpStatus) {
                    case 401: {
                        String errorMessage = this.getErrorMessageUnauthorized(response);
                        throw new UnauthorizedException(errorMessage);
                    }
                    case 404: {
                        String errorMessage = this.getErrorMessage(response, "No " + this.typeName + " with given id " + id);
                        throw new NoResultException(errorMessage);
                    }
                    case 409: {
                        String errorMessage = this.getErrorMessage(response, "Unable to delete: " + response.getStatusLine().getReasonPhrase());
                        throw new ConflictException(errorMessage);
                    }
                    case 403: {
                        String errorMessage = this.getErrorMessageForbidden(accessToken, "delete");
                        throw new ForbiddenException(errorMessage);
                    }
                }
                String errorMessage = this.getErrorMessageDefault(response, httpStatus);
                throw new ConnectionInitializationException(errorMessage);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw this.createSetupConnectionException(e);
        }
    }

    protected T createResource(T resource, AccessToken accessToken) {
        T t;
        this.ensureReferenceIsNotNull(resource, "The given " + this.typeName + " can't be null.");
        this.ensureAccessTokenIsNotNull(accessToken);
        InputStream content = null;
        try {
            T returnResource;
            HttpPost realWebResource = new HttpPost(this.webResource.getURI());
            realWebResource.addHeader(AUTHORIZATION, BEARER + accessToken.getToken());
            String userAsString = this.mapper.writeValueAsString(resource);
            realWebResource.setEntity((HttpEntity)new StringEntity(userAsString, this.contentType));
            this.httpclient = new DefaultHttpClient();
            HttpResponse response = this.httpclient.execute((HttpUriRequest)realWebResource);
            int httpStatus = response.getStatusLine().getStatusCode();
            if (httpStatus != 201) {
                switch (httpStatus) {
                    case 401: {
                        String errorMessage = this.getErrorMessageUnauthorized(response);
                        throw new UnauthorizedException(errorMessage);
                    }
                    case 409: {
                        String errorMessage = this.getErrorMessage(response, "Unable to save");
                        throw new ConflictException(errorMessage);
                    }
                    case 403: {
                        String errorMessage = this.getErrorMessageForbidden(accessToken, "create");
                        throw new ForbiddenException(errorMessage);
                    }
                }
                String errorMessage = this.getErrorMessageDefault(response, httpStatus);
                throw new ConnectionInitializationException(errorMessage);
            }
            content = response.getEntity().getContent();
            t = returnResource = this.mapSingleResourceResponse(content);
        }
        catch (IOException e) {
            throw this.createSetupConnectionException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (Exception ignore) {}
        }
        return t;
    }

    protected T updateResource(String id, T resource, AccessToken accessToken) {
        HttpPatch realWebResource = new HttpPatch(this.webResource.getURI() + "/" + id);
        return this.modifyResource(id, resource, accessToken, (HttpEntityEnclosingRequestBase)realWebResource);
    }

    protected T replaceResource(String id, T resource, AccessToken accessToken) {
        HttpPut realWebResource = new HttpPut(this.webResource.getURI() + "/" + id);
        return this.modifyResource(id, resource, accessToken, (HttpEntityEnclosingRequestBase)realWebResource);
    }

    private T modifyResource(String id, T resource, AccessToken accessToken, HttpEntityEnclosingRequestBase realWebResource) {
        T t;
        this.ensureReferenceIsNotNull(resource, "The given " + this.typeName + " can't be null.");
        this.ensureAccessTokenIsNotNull(accessToken);
        this.ensureReferenceIsNotNull(id, "The given id can't be null.");
        InputStream content = null;
        try {
            T returnResource;
            realWebResource.addHeader(AUTHORIZATION, BEARER + accessToken.getToken());
            String userAsString = this.mapper.writeValueAsString(resource);
            realWebResource.setEntity((HttpEntity)new StringEntity(userAsString, this.contentType));
            this.httpclient = new DefaultHttpClient();
            HttpResponse response = this.httpclient.execute((HttpUriRequest)realWebResource);
            int httpStatus = response.getStatusLine().getStatusCode();
            if (httpStatus != 200) {
                switch (httpStatus) {
                    case 401: {
                        String errorMessage = this.getErrorMessageUnauthorized(response);
                        throw new UnauthorizedException(errorMessage);
                    }
                    case 400: {
                        String errorMessage = this.getErrorMessage(response, "Wrong " + this.typeName + ". Unable to update");
                        throw new ConflictException(errorMessage);
                    }
                    case 409: {
                        String errorMessage = this.getErrorMessage(response, this.typeName + " with Conflicts. Unable to update");
                        throw new ConflictException(errorMessage);
                    }
                    case 404: {
                        String errorMessage = this.getErrorMessage(response, "A " + this.typeName + " with the id " + id + " could be found to be updated.");
                        throw new NotFoundException(errorMessage);
                    }
                    case 403: {
                        String errorMessage = this.getErrorMessageForbidden(accessToken, "update");
                        throw new ForbiddenException(errorMessage);
                    }
                }
                String errorMessage = this.getErrorMessageDefault(response, httpStatus);
                throw new ConnectionInitializationException(errorMessage);
            }
            content = response.getEntity().getContent();
            t = returnResource = this.mapSingleResourceResponse(content);
        }
        catch (IOException e) {
            throw this.createSetupConnectionException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (Exception ignore) {}
        }
        return t;
    }

    private void ensureAccessTokenIsNotNull(AccessToken accessToken) {
        this.ensureReferenceIsNotNull(accessToken, "The given accessToken can't be null.");
    }

    private void ensureReferenceIsNotNull(Object reference, String message) {
        if (reference == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private ConnectionInitializationException createSetupConnectionException(Throwable e) {
        return new ConnectionInitializationException("Unable to setup connection", e);
    }

    protected static class Builder<T> {
        private String endpoint;
        private Class<T> type;
        private String typeName;

        protected Builder(String endpoint) {
            this.endpoint = endpoint;
            this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.typeName = this.type.getSimpleName();
        }

        protected HttpGet getWebResource() {
            HttpGet webResource;
            try {
                webResource = new HttpGet(new URI(this.endpoint + "/" + this.typeName + "s"));
                webResource.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            }
            catch (URISyntaxException e) {
                throw new ConnectionInitializationException("Unable to setup connection " + this.endpoint + "is not a valid URI.", e);
            }
            return webResource;
        }
    }
}

