/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.update;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osiam.client.query.metamodel.User_;
import org.osiam.resources.scim.Address;
import org.osiam.resources.scim.Meta;
import org.osiam.resources.scim.MultiValuedAttribute;
import org.osiam.resources.scim.Name;
import org.osiam.resources.scim.User;

public final class UpdateUser {
    private User user;

    private UpdateUser(Builder builder) {
        this.user = builder.updateUser.build();
    }

    public User getScimConformUpdateUser() {
        return this.user;
    }

    public static class Builder {
        private String userName;
        private String nickName;
        private String externalId;
        private String locale;
        private String password;
        private String preferredLanguage;
        private String profileUrl;
        private String timezone;
        private String title;
        private Name name;
        private String userType;
        private String displayName;
        private Boolean active;
        private User.Builder updateUser = null;
        private Set<String> deleteFields = new HashSet<String>();
        private List<MultiValuedAttribute> emails = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> ims = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> groups = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> phoneNumbers = new ArrayList<MultiValuedAttribute>();
        private List<Address> addresses = new ArrayList<Address>();
        private List<MultiValuedAttribute> entitlements = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> photos = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> roles = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> certificates = new ArrayList<MultiValuedAttribute>();
        private static final String DELETE = "delete";

        public Builder updateUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder addAddress(Address address) {
            this.addresses.add(address);
            return this;
        }

        public Builder deleteAddress(Address address) {
            return this;
        }

        public Builder deleteAddresses() {
            this.deleteFields.add("addresses");
            return this;
        }

        public Builder updateAddress(Address oldAttribute, Address newAttribute) {
            this.deleteAddress(oldAttribute);
            this.addAddress(newAttribute);
            return this;
        }

        public Builder deleteNickName() {
            this.deleteFields.add(User_.nickName.toString());
            return this;
        }

        public Builder updateNickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public Builder deleteExternalId() {
            this.deleteFields.add(User_.externalId.toString());
            return this;
        }

        public Builder updateExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder deleteLocal() {
            this.deleteFields.add(User_.locale.toString());
            return this;
        }

        public Builder updateLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder updatePassword(String password) {
            this.password = password;
            return this;
        }

        public Builder deletePreferredLanguage() {
            this.deleteFields.add(User_.preferredLanguage.toString());
            return this;
        }

        public Builder updatePreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        public Builder deleteProfileUrl() {
            this.deleteFields.add(User_.profileUrl.toString());
            return this;
        }

        public Builder updateProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
            return this;
        }

        public Builder deleteTimezone() {
            this.deleteFields.add(User_.timezone.toString());
            return this;
        }

        public Builder updateTimezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder deleteTitle() {
            this.deleteFields.add(User_.title.toString());
            return this;
        }

        public Builder updateTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder deleteName() {
            this.deleteFields.add("name");
            return this;
        }

        public Builder updateName(Name name) {
            this.name = name;
            return this;
        }

        public Builder deleteUserType() {
            this.deleteFields.add(User_.userType.toString());
            return this;
        }

        public Builder updateUserType(String userType) {
            this.userType = userType;
            return this;
        }

        public Builder deleteDisplayName() {
            this.deleteFields.add(User_.displayName.toString());
            return this;
        }

        public Builder updateDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder deleteEmails() {
            this.deleteFields.add("emails");
            return this;
        }

        public Builder deleteEmail(MultiValuedAttribute email) {
            MultiValuedAttribute deleteEmail = new MultiValuedAttribute.Builder().setValue(email.getValue()).setType(email.getType()).setOperation(DELETE).build();
            this.emails.add(deleteEmail);
            return this;
        }

        public Builder addEmail(MultiValuedAttribute email) {
            this.emails.add(email);
            return this;
        }

        public Builder updateEmail(MultiValuedAttribute oldAttribute, MultiValuedAttribute newAttribute) {
            this.deleteEmail(oldAttribute);
            this.addEmail(newAttribute);
            return this;
        }

        public Builder deleteX509Certificates() {
            this.deleteFields.add("x509Certificates");
            return this;
        }

        public Builder deleteX509Certificate(MultiValuedAttribute certificate) {
            MultiValuedAttribute deleteCertificates = new MultiValuedAttribute.Builder().setValue(certificate.getValue()).setOperation(DELETE).build();
            this.certificates.add(deleteCertificates);
            return this;
        }

        public Builder addX509Certificate(MultiValuedAttribute certificate) {
            this.certificates.add(certificate);
            return this;
        }

        public Builder updateX509Certificate(MultiValuedAttribute oldAttribute, MultiValuedAttribute newAttribute) {
            this.deleteX509Certificate(oldAttribute);
            this.addX509Certificate(newAttribute);
            return this;
        }

        public Builder deleteRoles() {
            this.deleteFields.add("roles");
            return this;
        }

        public Builder deleteRole(MultiValuedAttribute role) {
            MultiValuedAttribute deleteRole = new MultiValuedAttribute.Builder().setValue(role.getValue()).setOperation(DELETE).build();
            this.roles.add(deleteRole);
            return this;
        }

        public Builder deleteRole(String role) {
            MultiValuedAttribute deleteRole = new MultiValuedAttribute.Builder().setValue((Object)role).setOperation(DELETE).build();
            this.roles.add(deleteRole);
            return this;
        }

        public Builder addRole(MultiValuedAttribute role) {
            this.roles.add(role);
            return this;
        }

        public Builder updateRole(MultiValuedAttribute oldAttribute, MultiValuedAttribute newAttribute) {
            this.deleteRole(oldAttribute);
            this.addRole(newAttribute);
            return this;
        }

        public Builder deleteIms() {
            this.deleteFields.add("ims");
            return this;
        }

        public Builder deleteIms(MultiValuedAttribute ims) {
            MultiValuedAttribute deleteIms = new MultiValuedAttribute.Builder().setValue(ims.getValue()).setType(ims.getType()).setOperation(DELETE).build();
            this.ims.add(deleteIms);
            return this;
        }

        public Builder addIms(MultiValuedAttribute ims) {
            this.ims.add(ims);
            return this;
        }

        public Builder updateIms(MultiValuedAttribute oldAttribute, MultiValuedAttribute newAttribute) {
            this.deleteIms(oldAttribute);
            this.addIms(newAttribute);
            return this;
        }

        public Builder addPhoneNumber(MultiValuedAttribute phoneNumber) {
            this.phoneNumbers.add(phoneNumber);
            return this;
        }

        public Builder deletePhoneNumber(MultiValuedAttribute phoneNumber) {
            MultiValuedAttribute deletePhoneNumber = new MultiValuedAttribute.Builder().setValue(phoneNumber.getValue()).setType(phoneNumber.getType()).setOperation(DELETE).build();
            this.phoneNumbers.add(deletePhoneNumber);
            return this;
        }

        public Builder deletePhoneNumbers() {
            this.deleteFields.add("phonenumbers");
            return this;
        }

        public Builder updatePhoneNumber(MultiValuedAttribute oldAttribute, MultiValuedAttribute newAttribute) {
            this.deletePhoneNumber(oldAttribute);
            this.addPhoneNumber(newAttribute);
            return this;
        }

        public Builder addPhoto(MultiValuedAttribute photo) {
            this.photos.add(photo);
            return this;
        }

        public Builder deletePhoto(MultiValuedAttribute photo) {
            MultiValuedAttribute deletePhoto = new MultiValuedAttribute.Builder().setValue(photo.getValue()).setType(photo.getType()).setOperation(DELETE).build();
            this.photos.add(deletePhoto);
            return this;
        }

        public Builder deletePhotos() {
            this.deleteFields.add("photos");
            return this;
        }

        public Builder updatePhotos(MultiValuedAttribute oldAttribute, MultiValuedAttribute newAttribute) {
            this.deletePhoto(oldAttribute);
            this.addPhoto(newAttribute);
            return this;
        }

        public Builder deleteEntitlements() {
            this.deleteFields.add("entitlements");
            return this;
        }

        public Builder deleteEntitlement(MultiValuedAttribute entitlement) {
            MultiValuedAttribute deleteEntitlement = new MultiValuedAttribute.Builder().setValue(entitlement.getValue()).setType(entitlement.getType()).setOperation(DELETE).build();
            this.entitlements.add(deleteEntitlement);
            return this;
        }

        public Builder addEntitlement(MultiValuedAttribute entitlement) {
            this.entitlements.add(entitlement);
            return this;
        }

        public Builder updateEntitlement(MultiValuedAttribute oldAttribute, MultiValuedAttribute newAttribute) {
            this.deleteEntitlement(oldAttribute);
            this.addEntitlement(newAttribute);
            return this;
        }

        public Builder deleteGroups() {
            this.deleteFields.add("groups");
            return this;
        }

        public Builder deleteGroup(String groupId) {
            MultiValuedAttribute deleteGroup = new MultiValuedAttribute.Builder().setValue((Object)groupId).setOperation(DELETE).build();
            this.groups.add(deleteGroup);
            return this;
        }

        public Builder deleteGroup(MultiValuedAttribute groupRef) {
            MultiValuedAttribute deleteGroup = new MultiValuedAttribute.Builder().setValue(groupRef.getValue()).setOperation(DELETE).build();
            this.groups.add(deleteGroup);
            return this;
        }

        public Builder addGroupMembership(MultiValuedAttribute groupMembership) {
            this.groups.add(groupMembership);
            return this;
        }

        public Builder updateActive(boolean active) {
            this.active = active;
            return this;
        }

        public UpdateUser build() {
            this.updateUser = this.userName != null ? new User.Builder(this.userName) : new User.Builder();
            if (this.nickName != null) {
                this.updateUser.setNickName(this.nickName);
            }
            if (this.externalId != null) {
                this.updateUser.setExternalId(this.externalId);
            }
            if (this.locale != null) {
                this.updateUser.setLocale(this.locale);
            }
            if (this.password != null) {
                this.updateUser.setPassword(this.password);
            }
            if (this.preferredLanguage != null) {
                this.updateUser.setPreferredLanguage(this.preferredLanguage);
            }
            if (this.profileUrl != null) {
                this.updateUser.setProfileUrl(this.profileUrl);
            }
            if (this.timezone != null) {
                this.updateUser.setTimezone(this.timezone);
            }
            if (this.title != null) {
                this.updateUser.setTitle(this.title);
            }
            if (this.name != null) {
                this.updateUser.setName(this.name);
            }
            if (this.userType != null) {
                this.updateUser.setUserType(this.userType);
            }
            if (this.displayName != null) {
                this.updateUser.setDisplayName(this.displayName);
            }
            if (this.active != null) {
                this.updateUser.setActive(this.active);
            }
            if (this.deleteFields.size() > 0) {
                Meta meta = new Meta.Builder().setAttributes(this.deleteFields).build();
                this.updateUser.setMeta(meta);
            }
            if (this.emails.size() > 0) {
                this.updateUser.setEmails(this.emails);
            }
            if (this.phoneNumbers.size() > 0) {
                this.updateUser.setPhoneNumbers(this.phoneNumbers);
            }
            if (this.addresses.size() > 0) {
                this.updateUser.setAddresses(this.addresses);
            }
            if (this.entitlements.size() > 0) {
                this.updateUser.setEntitlements(this.entitlements);
            }
            if (this.ims.size() > 0) {
                this.updateUser.setIms(this.ims);
            }
            if (this.photos.size() > 0) {
                this.updateUser.setPhotos(this.photos);
            }
            if (this.roles.size() > 0) {
                this.updateUser.setRoles(this.roles);
            }
            if (this.certificates.size() > 0) {
                this.updateUser.setX509Certificates(this.certificates);
            }
            return new UpdateUser(this);
        }
    }
}

