/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.oauth;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.Objects;

public class AccessToken {
    private static final int MILLIS = 1000;
    @JsonProperty(value="access_token")
    private String token;
    @JsonProperty(value="token_type")
    private String type;
    @JsonProperty(value="expires_in")
    private int expiresIn;
    @JsonProperty
    private String scope;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    private long retrievedOn = new Date().getTime();

    public String getToken() {
        return this.token;
    }

    public String getType() {
        return this.type;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public boolean isExpired() {
        long now = new Date().getTime();
        return now > this.retrievedOn + (long)this.expiresIn * 1000L;
    }

    public String getScope() {
        return this.scope;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String toString() {
        StringBuilder returnToken = new StringBuilder();
        returnToken.append("[access_token = ").append(this.token).append(", token_type = ").append(this.type).append(", scope = ").append(this.scope).append(", expired = ").append(this.isExpired()).append(", refresh_token = ").append(this.refreshToken).append("]");
        return returnToken.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        if (this.expiresIn != that.expiresIn) {
            return false;
        }
        if (!this.refreshToken.equals(that.refreshToken)) {
            return false;
        }
        if (!this.scope.equals(that.scope)) {
            return false;
        }
        if (!this.token.equals(that.token)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.isExpired() == that.isExpired();
    }

    public int hashCode() {
        return Objects.hash(this.token, this.type, this.expiresIn, this.scope, this.refreshToken, this.isExpired());
    }
}

