/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.update;

import java.util.HashSet;
import java.util.Set;
import org.osiam.client.query.metamodel.Group_;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.MemberRef;
import org.osiam.resources.scim.Meta;

public final class UpdateGroup {
    private Group group;

    private UpdateGroup(Builder builder) {
        this.group = builder.updateGroup.build();
    }

    public Group getScimConformUpdateGroup() {
        return this.group;
    }

    public static class Builder {
        private Group.Builder updateGroup = null;
        private String displayName = null;
        private String externalId = null;
        private Set<String> deleteFields = new HashSet<String>();
        private static final String DELETE = "delete";
        private Set<MemberRef> members = new HashSet<MemberRef>();

        public Builder deleteExternalId() {
            this.deleteFields.add(Group_.externalId.toString());
            return this;
        }

        public Builder updateExternalId(String externalID) {
            this.externalId = externalID;
            return this;
        }

        public Builder updateDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder deleteMembers() {
            this.deleteFields.add("members");
            return this;
        }

        public Builder deleteMember(String memberId) {
            MemberRef deleteGroup = new MemberRef.Builder().setValue(memberId).setOperation(DELETE).build();
            this.members.add(deleteGroup);
            return this;
        }

        public Builder addMember(String memberId) {
            MemberRef newGroup = new MemberRef.Builder().setValue(memberId).build();
            this.members.add(newGroup);
            return this;
        }

        public UpdateGroup build() {
            this.updateGroup = this.displayName != null ? new Group.Builder().setDisplayName(this.displayName) : new Group.Builder();
            if (this.externalId != null) {
                this.updateGroup.setExternalId(this.externalId);
            }
            if (this.deleteFields.size() > 0) {
                Meta meta = new Meta.Builder().setAttributes(this.deleteFields).build();
                this.updateGroup.setMeta(meta);
            }
            if (this.members.size() > 0) {
                this.updateGroup.setMembers(this.members);
            }
            return new UpdateGroup(this);
        }
    }
}

