/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.logging.service;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import org.osgl.logging.LogService;
import org.osgl.logging.Logger;

public class LogbackService
implements LogService {
    protected final Logger logger;

    public LogbackService(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void setLevel(Logger.Level level) {
        this.logger.setLevel(this.convert(level));
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.logger.trace(msg);
    }

    @Override
    public void trace(Throwable t, String msg) {
        this.logger.trace(msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.logger.debug(msg);
    }

    @Override
    public void debug(Throwable t, String msg) {
        this.logger.debug(msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void info(Throwable t, String msg) {
        this.logger.info(msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor(Level.WARN);
    }

    @Override
    public void warn(String msg) {
        this.logger.warn(msg);
    }

    @Override
    public void warn(Throwable t, String msg) {
        this.logger.warn(msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor(Level.ERROR);
    }

    @Override
    public void error(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void error(Throwable t, String msg) {
        this.logger.error(msg, t);
    }

    @Override
    public void fatal(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void fatal(Throwable t, String msg) {
        this.logger.error(msg, t);
    }

    private Level convert(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
        }
        return Level.ERROR;
    }
}

