/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.logging.service;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.osgl.logging.LogService;
import org.osgl.logging.Logger;

public class Log4jService
implements LogService {
    protected final Logger logger;

    public Log4jService(Class<?> clz) {
        this.logger = Logger.getLogger(clz);
    }

    public Log4jService(String name) {
        this.logger = Logger.getLogger((String)name);
    }

    @Override
    public void setLevel(Logger.Level level) {
        this.logger.setLevel(this.convert(level));
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.logger.trace((Object)msg);
    }

    @Override
    public void trace(Throwable t, String msg) {
        this.logger.trace((Object)msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.logger.debug((Object)msg);
    }

    @Override
    public void debug(Throwable t, String msg) {
        this.logger.debug((Object)msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        this.logger.info((Object)msg);
    }

    @Override
    public void info(Throwable t, String msg) {
        this.logger.info((Object)msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void warn(String msg) {
        this.logger.warn((Object)msg);
    }

    @Override
    public void warn(Throwable t, String msg) {
        this.logger.warn((Object)msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public void error(String msg) {
        this.logger.error((Object)msg);
    }

    @Override
    public void error(Throwable t, String msg) {
        this.logger.error((Object)msg, t);
    }

    @Override
    public void fatal(String msg) {
        this.logger.fatal((Object)msg);
    }

    @Override
    public void fatal(Throwable t, String msg) {
        this.logger.fatal((Object)msg, t);
    }

    private Level convert(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        return Level.FATAL;
    }
}

