/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.h2gis.utilities.GeometryTypeCodes;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.h2gis.utilities.wrapper.DataSourceWrapper;

public class SFSUtilities {
    private static final Map<Integer, String> TYPE_MAP = new HashMap<Integer, String>();
    private static final Map<String, Integer> GEOM_TYPE_TO_SFS_CODE = new HashMap<String, Integer>();

    public static String getGeometryTypeNameFromCode(int geometryTypeCode) {
        return TYPE_MAP.get(geometryTypeCode);
    }

    public static int getGeometryTypeFromGeometry(Geometry geometry) {
        Integer sfsGeomCode = GEOM_TYPE_TO_SFS_CODE.get(geometry.getGeometryType().toLowerCase());
        if (sfsGeomCode == null) {
            return 0;
        }
        return sfsGeomCode;
    }

    public static int getGeometryType(Connection connection, TableLocation location, String fieldName) throws SQLException {
        if (fieldName == null || fieldName.isEmpty()) {
            List<String> geometryFields = SFSUtilities.getGeometryFields(connection, location);
            if (geometryFields.isEmpty()) {
                throw new SQLException("The table " + location + " does not contain a Geometry field, then geometry type cannot be computed");
            }
            fieldName = geometryFields.get(0);
        }
        ResultSet geomResultSet = SFSUtilities.getGeometryColumnsView(connection, location.getCatalog(), location.getSchema(), location.getTable());
        boolean isH2 = JDBCUtilities.isH2DataBase(connection.getMetaData());
        while (geomResultSet.next()) {
            if (!fieldName.isEmpty() && !geomResultSet.getString("F_GEOMETRY_COLUMN").equalsIgnoreCase(fieldName)) continue;
            if (isH2) {
                return geomResultSet.getInt("GEOMETRY_TYPE");
            }
            return GEOM_TYPE_TO_SFS_CODE.get(geomResultSet.getString("type").toLowerCase());
        }
        throw new SQLException("Field not found " + fieldName);
    }

    public static DataSource wrapSpatialDataSource(DataSource dataSource) {
        try {
            if (dataSource.isWrapperFor(DataSourceWrapper.class)) {
                return dataSource;
            }
            return new DataSourceWrapper(dataSource);
        }
        catch (SQLException ex) {
            return new DataSourceWrapper(dataSource);
        }
    }

    public static Connection wrapConnection(Connection connection) {
        try {
            if (connection.isWrapperFor(ConnectionWrapper.class)) {
                return connection;
            }
            return new ConnectionWrapper(connection);
        }
        catch (SQLException ex) {
            return new ConnectionWrapper(connection);
        }
    }

    public static Envelope getTableEnvelope(Connection connection, TableLocation location, String geometryField) throws SQLException {
        ResultSet rs;
        if (geometryField == null || geometryField.isEmpty()) {
            List<String> geometryFields = SFSUtilities.getGeometryFields(connection, location);
            if (geometryFields.isEmpty()) {
                throw new SQLException("The table " + location + " does not contain a Geometry field, then the extent cannot be computed");
            }
            geometryField = geometryFields.get(0);
        }
        if ((rs = connection.createStatement().executeQuery("SELECT ST_Extent(" + TableLocation.quoteIdentifier(geometryField) + ") ext FROM " + location)).next()) {
            return ((Geometry)rs.getObject(1)).getEnvelopeInternal();
        }
        throw new SQLException("Unable to get the table extent it may be empty");
    }

    public static List<String> getGeometryFields(Connection connection, TableLocation location) throws SQLException {
        return SFSUtilities.getGeometryFields(connection, location.getCatalog(), location.getSchema(), location.getTable());
    }

    public static PreparedStatement prepareInformationSchemaStatement(Connection connection, String catalog, String schema, String table, String informationSchemaTable, String endQuery, String catalog_field, String schema_field, String table_field) throws SQLException {
        Integer n;
        Integer n2;
        Integer catalogIndex = null;
        Integer schemaIndex = null;
        Integer tableIndex = 1;
        StringBuilder sb = new StringBuilder("SELECT * from " + informationSchemaTable + " where ");
        if (!catalog.isEmpty()) {
            sb.append("UPPER(");
            sb.append(catalog_field);
            sb.append(") = ? AND ");
            catalogIndex = 1;
            n2 = tableIndex;
            n = tableIndex = Integer.valueOf(tableIndex + 1);
        }
        if (!schema.isEmpty()) {
            sb.append("UPPER(");
            sb.append(schema_field);
            sb.append(") = ? AND ");
            schemaIndex = tableIndex;
            n2 = tableIndex;
            n = tableIndex = Integer.valueOf(tableIndex + 1);
        }
        sb.append("UPPER(");
        sb.append(table_field);
        sb.append(") = ? ");
        sb.append(endQuery);
        PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());
        if (catalogIndex != null) {
            preparedStatement.setString(catalogIndex, catalog.toUpperCase());
        }
        if (schemaIndex != null) {
            preparedStatement.setString(schemaIndex, schema.toUpperCase());
        }
        preparedStatement.setString(tableIndex, table.toUpperCase());
        return preparedStatement;
    }

    public static PreparedStatement prepareInformationSchemaStatement(Connection connection, String catalog, String schema, String table, String informationSchemaTable, String endQuery) throws SQLException {
        return SFSUtilities.prepareInformationSchemaStatement(connection, catalog, schema, table, informationSchemaTable, endQuery, "f_table_catalog", "f_table_schema", "f_table_name");
    }

    private static ResultSet getGeometryColumnsView(Connection connection, String catalog, String schema, String table) throws SQLException {
        PreparedStatement geomStatement = SFSUtilities.prepareInformationSchemaStatement(connection, catalog, schema, table, "geometry_columns", "");
        return geomStatement.executeQuery();
    }

    public static List<String> getGeometryFields(Connection connection, String catalog, String schema, String table) throws SQLException {
        LinkedList<String> fieldsName = new LinkedList<String>();
        ResultSet geomResultSet = SFSUtilities.getGeometryColumnsView(connection, catalog, schema, table);
        while (geomResultSet.next()) {
            fieldsName.add(geomResultSet.getString("f_geometry_column"));
        }
        geomResultSet.close();
        return fieldsName;
    }

    public static List<String> getGeometryFields(ResultSet resultSet) throws SQLException {
        LinkedList<String> fieldsName = new LinkedList<String>();
        ResultSetMetaData meta = resultSet.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!meta.getColumnTypeName(i).equalsIgnoreCase("geometry")) continue;
            fieldsName.add(meta.getColumnName(i));
        }
        return fieldsName;
    }

    public static int getFirstGeometryFieldIndex(ResultSet resultSet) throws SQLException {
        ResultSetMetaData meta = resultSet.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!meta.getColumnTypeName(i).equalsIgnoreCase("geometry")) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasGeometryField(ResultSet resultSet) throws SQLException {
        ResultSetMetaData meta = resultSet.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!meta.getColumnTypeName(i).equalsIgnoreCase("geometry")) continue;
            return true;
        }
        return false;
    }

    public static Envelope getResultSetEnvelope(ResultSet resultSet) throws SQLException {
        List<String> geometryFields = SFSUtilities.getGeometryFields(resultSet);
        if (geometryFields.isEmpty()) {
            throw new SQLException("This resultset doesn't contain any geometry field.");
        }
        return SFSUtilities.getResultSetEnvelope(resultSet, geometryFields.get(0));
    }

    public static Envelope getResultSetEnvelope(ResultSet resultSet, String fieldName) throws SQLException {
        Envelope aggregatedEnvelope = null;
        while (resultSet.next()) {
            Geometry geom = (Geometry)resultSet.getObject(fieldName);
            if (aggregatedEnvelope != null) {
                aggregatedEnvelope.expandToInclude(geom.getEnvelopeInternal());
                continue;
            }
            aggregatedEnvelope = geom.getEnvelopeInternal();
        }
        return aggregatedEnvelope;
    }

    public static int getSRID(Connection connection, TableLocation table) throws SQLException {
        ResultSet geomResultSet = SFSUtilities.getGeometryColumnsView(connection, table.getCatalog(), table.getSchema(), table.getTable());
        int srid = 0;
        if (geomResultSet.next()) {
            srid = geomResultSet.getInt("srid");
        }
        geomResultSet.close();
        return srid;
    }

    public static int getSRID(Connection connection, TableLocation table, String fieldName) throws SQLException {
        ResultSet geomResultSet = SFSUtilities.getGeometryColumnsView(connection, table.getCatalog(), table.getSchema(), table.getTable());
        int srid = 0;
        while (geomResultSet.next()) {
            if (!geomResultSet.getString("f_geometry_column").equals(fieldName)) continue;
            srid = geomResultSet.getInt("srid");
            break;
        }
        geomResultSet.close();
        return srid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAuthorityAndSRID(Connection connection, TableLocation table, String fieldName) throws SQLException {
        ResultSet geomResultSet = SFSUtilities.getGeometryColumnsView(connection, table.getCatalog(), table.getSchema(), table.getTable());
        int srid = 0;
        while (geomResultSet.next()) {
            if (!geomResultSet.getString("f_geometry_column").equals(fieldName)) continue;
            srid = geomResultSet.getInt("srid");
            break;
        }
        geomResultSet.close();
        String authority = null;
        String sridCode = null;
        if (srid != 0) {
            StringBuilder sb = new StringBuilder("SELECT AUTH_NAME FROM ");
            sb.append("PUBLIC.SPATIAL_REF_SYS ").append(" WHERE SRID = ?");
            PreparedStatement ps = connection.prepareStatement(sb.toString());
            ps.setInt(1, srid);
            ResultSet rs = null;
            try {
                rs = ps.executeQuery();
                if (rs.next()) {
                    authority = rs.getString(1);
                    sridCode = String.valueOf(srid);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                ps.close();
            }
        }
        return new String[]{authority, sridCode};
    }

    public static void addTableSRIDConstraint(Connection connection, TableLocation tableLocation, int srid) throws SQLException {
        if (srid > 0) {
            connection.createStatement().execute(String.format("ALTER TABLE %s ADD CONSTRAINT enforce_srid_geom CHECK ST_SRID(the_geom)= %d", tableLocation.toString(), srid));
        }
    }

    static {
        GEOM_TYPE_TO_SFS_CODE.put("point", 1);
        GEOM_TYPE_TO_SFS_CODE.put("linestring", 2);
        GEOM_TYPE_TO_SFS_CODE.put("polygon", 3);
        GEOM_TYPE_TO_SFS_CODE.put("multipoint", 4);
        GEOM_TYPE_TO_SFS_CODE.put("multilinestring", 5);
        GEOM_TYPE_TO_SFS_CODE.put("multipolygon", 6);
        GEOM_TYPE_TO_SFS_CODE.put("geometry", 0);
        GEOM_TYPE_TO_SFS_CODE.put("geometrycollection", 7);
        for (Field field : GeometryTypeCodes.class.getDeclaredFields()) {
            try {
                TYPE_MAP.put(field.getInt(null), field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

