/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.system;

import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueInt;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class IntegerRange
extends DeterministicScalarFunction {
    public IntegerRange() {
        this.addProperty("remarks", "Return an array of integers within the range [start-end). \nThe default step increment is 1 but the user can set another one.");
    }

    public String getJavaStaticMethod() {
        return "createArray";
    }

    public static ValueArray createArray(int begin, int end) {
        return IntegerRange.createArray(begin, end, 1);
    }

    public static ValueArray createArray(int begin, int end, int step) {
        if (end < begin) {
            throw new IllegalArgumentException("End must be greater or equal to begin");
        }
        int nbClasses = (end - begin) / step;
        ValueInt[] getArray = new ValueInt[nbClasses];
        for (int i = 0; i < nbClasses; ++i) {
            getArray[i] = ValueInt.get((int)(i * step + begin));
        }
        return ValueArray.get((Value[])getArray);
    }
}

