/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.topography;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.math.Vector3D;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;
import org.h2gis.h2spatialext.function.spatial.topography.TINFeatureFactory;
import org.h2gis.utilities.jts_utils.CoordinateUtils;
import org.h2gis.utilities.jts_utils.TriMarkers;

public class ST_TriangleDirection
extends DeterministicScalarFunction {
    private static final GeometryFactory gf = new GeometryFactory();

    public ST_TriangleDirection() {
        this.addProperty("remarks", "Compute the steepest vector director for a triangle\nand represent it as a linestring");
    }

    public String getJavaStaticMethod() {
        return "computeDirection";
    }

    public static LineString computeDirection(Geometry geometry) throws IllegalArgumentException {
        if (geometry == null) {
            return null;
        }
        Triangle triangle = TINFeatureFactory.createTriangle(geometry);
        Vector3D normal = TriMarkers.getNormalVector((Triangle)triangle);
        Vector3D vector = new Vector3D(normal.getX(), normal.getY(), 0.0).normalize();
        Coordinate inCenter = triangle.centroid();
        inCenter.setOrdinate(2, Triangle.interpolateZ((Coordinate)inCenter, (Coordinate)triangle.p0, (Coordinate)triangle.p1, (Coordinate)triangle.p2));
        LineSegment[] sides = new LineSegment[]{new LineSegment(triangle.p0, triangle.p1), new LineSegment(triangle.p1, triangle.p2), new LineSegment(triangle.p2, triangle.p0)};
        Coordinate pointIntersection = null;
        double nearestIntersection = Double.MAX_VALUE;
        for (LineSegment side : sides) {
            double distInters;
            Coordinate intersection = CoordinateUtils.vectorIntersection((Coordinate)inCenter, (Vector3D)vector, (Coordinate)side.p0, (Vector3D)new Vector3D(side.p0, side.p1).normalize());
            double d = distInters = intersection == null ? Double.MAX_VALUE : side.distance(intersection);
            if (intersection == null || !(distInters < nearestIntersection)) continue;
            pointIntersection = new Coordinate(intersection.x, intersection.y, Triangle.interpolateZ((Coordinate)intersection, (Coordinate)triangle.p0, (Coordinate)triangle.p1, (Coordinate)triangle.p2));
            nearestIntersection = distInters;
        }
        if (pointIntersection != null) {
            return gf.createLineString(new Coordinate[]{inCenter, pointIntersection});
        }
        return gf.createLineString(new Coordinate[0]);
    }
}

