/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.topography;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueString;
import org.h2gis.h2spatial.TableFunctionUtil;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.jts_utils.Contouring;
import org.h2gis.utilities.jts_utils.TriMarkers;

public class ST_TriangleContouring
extends DeterministicScalarFunction {
    public static final String ISO_FIELD_NAME = "IDISO";
    private static final String HACK_URL = "jdbc:columnlist:connection";

    public ST_TriangleContouring() {
        this.addProperty("remarks", "Split triangle into polygons within the specified range of values.\nIso contouring using Z:\nselect * from ST_TRIANGLECONTOURING('input_table',10,20,30,40)\nIso contouring using table columns\nSELECT * FROM ST_TRIANGLECONTOURING('input_table','m1','m2','m3',10,20,30,40)");
        this.addProperty("nobuffer", true);
    }

    public String getJavaStaticMethod() {
        return "triangleContouring";
    }

    public static ResultSet triangleContouring(Connection connection, String tableName, Value ... varArgs) throws SQLException {
        ArrayList<Double> isoLvls;
        if (connection.getMetaData().getURL().equals(HACK_URL)) {
            return new ExplodeResultSet(connection, tableName, Arrays.asList(0.0)).getResultSet();
        }
        ExplodeResultSet rowSource = null;
        if (varArgs.length > 3 && varArgs[0] instanceof ValueString && varArgs[1] instanceof ValueString && varArgs[2] instanceof ValueString) {
            isoLvls = new ArrayList(varArgs.length - 3);
            for (int idArg = 3; idArg < varArgs.length; ++idArg) {
                isoLvls.add(varArgs[idArg].getDouble());
            }
            rowSource = new ExplodeResultSet(connection, tableName, varArgs[0].getString(), varArgs[1].getString(), varArgs[2].getString(), isoLvls);
        }
        if (rowSource == null) {
            isoLvls = new ArrayList<Double>(varArgs.length);
            for (Value value : varArgs) {
                if (value instanceof ValueArray) {
                    for (Value arrVal : ((ValueArray)value).getList()) {
                        isoLvls.add(arrVal.getDouble());
                    }
                    continue;
                }
                isoLvls.add(value.getDouble());
            }
            rowSource = new ExplodeResultSet(connection, tableName, isoLvls);
        }
        return rowSource.getResultSet();
    }

    private static class ValueOnField
    implements TriMarkersFactory {
        private final int vertex1FieldIndex;
        private final int vertex2FieldIndex;
        private final int vertex3FieldIndex;
        private final ResultSet rs;

        private ValueOnField(int vertex1FieldIndex, int vertex2FieldIndex, int vertex3FieldIndex, ResultSet rs) {
            this.vertex1FieldIndex = vertex1FieldIndex;
            this.vertex2FieldIndex = vertex2FieldIndex;
            this.vertex3FieldIndex = vertex3FieldIndex;
            this.rs = rs;
        }

        @Override
        public TriMarkers getTriangle(Coordinate[] pts) throws SQLException {
            return new TriMarkers(pts[0], pts[1], pts[2], this.rs.getDouble(this.vertex1FieldIndex), this.rs.getDouble(this.vertex2FieldIndex), this.rs.getDouble(this.vertex3FieldIndex));
        }
    }

    private static class ValueOnZ
    implements TriMarkersFactory {
        private ValueOnZ() {
        }

        @Override
        public TriMarkers getTriangle(Coordinate[] pts) throws SQLException {
            return new TriMarkers(pts[0], pts[1], pts[2], pts[0].z, pts[1].z, pts[2].z);
        }
    }

    private static interface TriMarkersFactory {
        public TriMarkers getTriangle(Coordinate[] var1) throws SQLException;
    }

    private static class GeneratedTriangle {
        private final Polygon triangle;
        private final int idIso;

        private GeneratedTriangle(Polygon triangle, int idIso) {
            this.triangle = triangle;
            this.idIso = idIso;
        }

        public Polygon getTriangle() {
            return this.triangle;
        }

        public int getIdIso() {
            return this.idIso;
        }
    }

    private static class ExplodeResultSet
    implements SimpleRowSource {
        private boolean firstRow = true;
        private ResultSet tableQuery;
        private boolean endOfResultSet = false;
        private String tableName;
        private String spatialFieldName;
        private Integer spatialFieldIndex;
        private int columnCount;
        private Queue<GeneratedTriangle> generatedRows = new LinkedList<GeneratedTriangle>();
        private Connection connection;
        private boolean useZ;
        private String isoFieldName1 = "";
        private String isoFieldName2 = "";
        private String isoFieldName3 = "";
        private TriMarkersFactory triFactory;
        private List<Double> isoLvls;
        private GeometryFactory factory = new GeometryFactory();

        private ExplodeResultSet(Connection connection, String tableName, String isoField1, String isoField2, String isoField3, List<Double> isoLvls) {
            this.tableName = tableName;
            this.spatialFieldName = "";
            this.connection = connection;
            this.useZ = false;
            this.isoFieldName1 = isoField1;
            this.isoFieldName2 = isoField2;
            this.isoFieldName3 = isoField3;
            this.isoLvls = isoLvls;
        }

        private ExplodeResultSet(Connection connection, String tableName, List<Double> isoLvls) {
            this.tableName = tableName;
            this.spatialFieldName = "";
            this.connection = connection;
            this.useZ = true;
            this.isoLvls = isoLvls;
        }

        public Object[] readRow() throws SQLException {
            if (this.firstRow) {
                this.reset();
            }
            while (this.generatedRows.isEmpty() && !this.endOfResultSet) {
                this.parseRow();
            }
            if (this.generatedRows.isEmpty()) {
                return null;
            }
            Object[] objects = new Object[this.columnCount + 1];
            GeneratedTriangle result = this.generatedRows.remove();
            for (int i = 1; i <= this.columnCount + 1; ++i) {
                objects[i - 1] = i == this.spatialFieldIndex ? result.getTriangle() : (i == this.columnCount + 1 ? Integer.valueOf(result.getIdIso()) : this.tableQuery.getObject(i));
            }
            return objects;
        }

        public void close() {
            if (this.tableQuery != null) {
                try {
                    this.tableQuery.close();
                    this.tableQuery = null;
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        private void parseRow() throws SQLException {
            this.generatedRows.clear();
            if (this.tableQuery.next()) {
                Geometry inputTriangle = (Geometry)this.tableQuery.getObject(this.spatialFieldIndex);
                if (inputTriangle == null || inputTriangle.getNumPoints() != 4) {
                    throw new SQLException("Invalid geometry input, got " + (inputTriangle == null ? "null" : inputTriangle.toText()));
                }
                TriMarkers triangle = this.triFactory.getTriangle(inputTriangle.getCoordinates());
                Map result = Contouring.processTriangle((TriMarkers)triangle, this.isoLvls);
                for (Map.Entry isoResult : result.entrySet()) {
                    for (TriMarkers outputTriangle : (Deque)isoResult.getValue()) {
                        Coordinate[] pverts = new Coordinate[]{outputTriangle.p0, outputTriangle.p1, outputTriangle.p2, outputTriangle.p0};
                        Polygon polygon = this.factory.createPolygon(this.factory.createLinearRing(pverts), null);
                        this.generatedRows.add(new GeneratedTriangle(polygon, ((Short)isoResult.getKey()).shortValue()));
                    }
                }
            } else {
                this.endOfResultSet = true;
            }
        }

        public void reset() throws SQLException {
            if (this.tableQuery != null && !this.tableQuery.isClosed()) {
                this.close();
            }
            Statement st = this.connection.createStatement();
            this.tableQuery = st.executeQuery("SELECT * FROM " + this.tableName);
            this.firstRow = false;
            ResultSetMetaData meta = this.tableQuery.getMetaData();
            this.columnCount = meta.getColumnCount();
            if (this.spatialFieldName.isEmpty()) {
                List geomFields = SFSUtilities.getGeometryFields((Connection)this.connection, (TableLocation)TableLocation.parse((String)this.tableName));
                if (!geomFields.isEmpty()) {
                    this.spatialFieldName = (String)geomFields.get(0);
                    this.spatialFieldIndex = this.tableQuery.findColumn((String)SFSUtilities.getGeometryFields((ResultSet)this.tableQuery).get(0));
                } else {
                    throw new SQLException("The table " + this.tableName + " does not contain a geometry field");
                }
            }
            if (this.useZ) {
                this.triFactory = new ValueOnZ();
            } else {
                int vertex1FieldIndex = this.tableQuery.findColumn(this.isoFieldName1);
                int vertex2FieldIndex = this.tableQuery.findColumn(this.isoFieldName2);
                int vertex3FieldIndex = this.tableQuery.findColumn(this.isoFieldName3);
                this.triFactory = new ValueOnField(vertex1FieldIndex, vertex2FieldIndex, vertex3FieldIndex, this.tableQuery);
            }
            if (this.spatialFieldIndex == null) {
                throw new SQLException("Geometry field " + this.spatialFieldName + " of table " + this.tableName + " not found");
            }
        }

        public ResultSet getResultSet() throws SQLException {
            SimpleResultSet rs = new SimpleResultSet((SimpleRowSource)this);
            TableFunctionUtil.copyFields((Connection)this.connection, (SimpleResultSet)rs, (TableLocation)TableLocation.parse((String)this.tableName, (Boolean)JDBCUtilities.isH2DataBase((DatabaseMetaData)this.connection.getMetaData())));
            rs.addColumn(ST_TriangleContouring.ISO_FIELD_NAME, 4, 10, 0);
            return rs;
        }
    }
}

