/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.topography;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.math.Vector2D;
import com.vividsolutions.jts.math.Vector3D;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;
import org.h2gis.h2spatialext.function.spatial.topography.TINFeatureFactory;
import org.h2gis.utilities.jts_utils.TriMarkers;

public class ST_TriangleAspect
extends DeterministicScalarFunction {
    public ST_TriangleAspect() {
        this.addProperty("remarks", "Compute the aspect of steepest downhill slope for a triangle\n. The aspect value is expressed in degrees compared to the north direction.");
    }

    public String getJavaStaticMethod() {
        return "computeAspect";
    }

    public static Double computeAspect(Geometry geometry) throws IllegalArgumentException {
        if (geometry == null) {
            return null;
        }
        Vector3D vector = TriMarkers.getSteepestVector((Vector3D)TriMarkers.getNormalVector((Triangle)TINFeatureFactory.createTriangle(geometry)), (double)1.0E-12);
        if (vector.length() < 1.0E-12) {
            return 0.0;
        }
        Vector2D v = new Vector2D(vector.getX(), vector.getY());
        return ST_TriangleAspect.measureFromNorth(Math.toDegrees(v.angle()));
    }

    public static double measureFromNorth(double angle) {
        return (450.0 - angle) % 360.0;
    }
}

