/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.mesh;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.sql.SQLException;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;
import org.h2gis.h2spatialext.function.spatial.mesh.DelaunayData;

public class ST_ConstrainedDelaunay
extends DeterministicScalarFunction {
    public ST_ConstrainedDelaunay() {
        this.addProperty("remarks", "Returns polygons that represent a Constrained Delaunay Triangulation from a geometry.\nOutput is a COLLECTION of polygons, for flag=0 (default flag) or a MULTILINESTRING for flag=1.\nIf the input geometry does not contain any lines, a delaunay triangulation will be computed.\n");
    }

    public String getJavaStaticMethod() {
        return "createCDT";
    }

    public static GeometryCollection createCDT(Geometry geometry) throws SQLException {
        return ST_ConstrainedDelaunay.createCDT(geometry, 0);
    }

    public static GeometryCollection createCDT(Geometry geometry, int flag) throws SQLException {
        if (geometry != null) {
            DelaunayData delaunayData = new DelaunayData();
            delaunayData.put(geometry, DelaunayData.MODE.CONSTRAINED);
            delaunayData.triangulate();
            if (flag == 0) {
                return delaunayData.getTriangles();
            }
            if (flag == 1) {
                return delaunayData.getTrianglesSides();
            }
            throw new SQLException("Only flag 0 or 1 is supported.");
        }
        return null;
    }
}

